/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import network.minter.blockchain.models.NodeResult;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class CandidateItem
extends NodeResult {
    @SerializedName(value="reward_address")
    public MinterAddress rewardAddress;
    @SerializedName(value="owner_address")
    public MinterAddress ownerAddress;
    @SerializedName(value="control_address")
    public MinterAddress controlAddress;
    @SerializedName(value="total_stake")
    public BigInteger totalStake;
    @SerializedName(value="public_key")
    public MinterPublicKey publicKey;
    public int commission;
    @SerializedName(value="used_slots")
    public BigInteger usedSlots;
    @SerializedName(value="uniq_users")
    public BigInteger uniqueUsers;
    @SerializedName(value="min_stake")
    public BigInteger minStake;
    public List<StakeInfo> stakes;
    public Status status;

    public BigDecimal getTotalStakeDecimal() {
        return Transaction.humanizeValue(this.totalStake);
    }

    @Parcel
    public static class StakeInfo {
        public MinterAddress owner;
        public StakeCoin coin;
        public BigInteger value;
        public BigInteger bipValue;

        public BigDecimal getValue() {
            return Transaction.humanizeValue(this.value);
        }

        public BigDecimal getBipValueDecimal() {
            return Transaction.humanizeValue(this.bipValue);
        }
    }

    @Parcel
    public static class StakeCoin {
        public BigInteger id;
        public String symbol;
    }

    public static final class Status
    extends Enum<Status> {
        @SerializedName(value="0")
        public static final /* enum */ Status Unknown;
        @SerializedName(value="1")
        public static final /* enum */ Status CandidateOff;
        @SerializedName(value="2")
        public static final /* enum */ Status CandidateOn;
        @SerializedName(value="3")
        public static final /* enum */ Status ValidatorOn;
        private static final /* synthetic */ Status[] $VALUES;
        private final int val;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }

        private Status(int n2) {
            this.val = n2;
        }

        static {
            Status status;
            Status status2;
            Status status3;
            Status status4;
            Status status5 = status4;
            Unknown = new Status(0);
            Status status6 = status3;
            CandidateOff = new Status(1);
            Status status7 = status2;
            CandidateOn = new Status(2);
            Status status8 = status;
            ValidatorOn = new Status(3);
            $VALUES = new Status[]{status5, status6, status7, status8};
        }

        public int getValue() {
            return this.val;
        }
    }
}

