package network.minter.blockchain.samples.coin_info;

import java.math.BigInteger;

import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import network.minter.blockchain.MinterBlockChainSDK;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.repo.NodeCoinRepository;

public class get {

    public static void main(String[] args) {
        MinterBlockChainSDK.initialize("https://minter-node-1.testnet.minter.network:8841");

        NodeCoinRepository repository = MinterBlockChainSDK.getInstance().coin();
        Observable<Coin> requestByName = repository.getCoinInfo("TESTCOIN");

        // for android use RxJava for android and recommended schedulers:
        // request
        //  .observeOn(Schedulers.io)
        //  .subscribeOn(AndroidSchedulers.mainThread())
        //  .subscribe(result -> {}, err -> {})
        requestByName
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });


        // do same request, but with coin ID
        Observable<Coin> requestById = repository.getCoinInfoById(new BigInteger("1"));

        requestById
                .subscribeOn(Schedulers.computation())
                .blockingSubscribe(result -> {
                    // handle result
                }, err -> {
                    // handle error
                });
    }
}
