/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxDeclareCandidacy
extends Operation {
    public static final Parcelable.Creator<TxDeclareCandidacy> CREATOR = new Parcelable.Creator<TxDeclareCandidacy>(){

        public TxDeclareCandidacy createFromParcel(Parcel parcel) {
            return new TxDeclareCandidacy(parcel);
        }

        public TxDeclareCandidacy[] newArray(int n) {
            return new TxDeclareCandidacy[n];
        }
    };
    private MinterAddress mAddress;
    private MinterPublicKey mPubKey;
    private Integer mCommission;
    private String mCoin;
    private BigInteger mStake;

    public TxDeclareCandidacy() {
    }

    public TxDeclareCandidacy(Transaction transaction) {
        super(transaction);
    }

    protected TxDeclareCandidacy(Parcel parcel) {
        super(parcel);
        this.mAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mPubKey = (MinterPublicKey)parcel.readValue(MinterPublicKey.class.getClassLoader());
        Integer n = parcel.readByte() == 0 ? null : Integer.valueOf(parcel.readInt());
        this.mCommission = n;
        this.mCoin = parcel.readString();
        this.mStake = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxDeclareCandidacy txDeclareCandidacy = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txDeclareCandidacy.mAddress);
        parcel.writeValue((Object)this.mPubKey);
        if (this.mCommission == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeInt(this.mCommission.intValue());
        }
        parcel.writeString(this.mCoin);
        parcel.writeValue((Object)this.mStake);
    }

    public MinterAddress getAddress() {
        return this.mAddress;
    }

    public TxDeclareCandidacy setAddress(String string) {
        this.mAddress = new MinterAddress((CharSequence)string);
        return this;
    }

    public TxDeclareCandidacy setAddress(MinterAddress minterAddress) {
        this.mAddress = minterAddress;
        return this;
    }

    public MinterPublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDeclareCandidacy setPublicKey(String string) {
        this.mPubKey = new MinterPublicKey((CharSequence)string);
        return this;
    }

    public TxDeclareCandidacy setPublicKey(byte[] byArray) {
        this.mPubKey = new MinterPublicKey(byArray);
        return this;
    }

    public TxDeclareCandidacy setPublicKey(MinterPublicKey minterPublicKey) {
        this.mPubKey = minterPublicKey;
        return this;
    }

    public int getCommission() {
        return this.mCommission;
    }

    public TxDeclareCandidacy setCommission(Integer n) {
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)"Commission must be unsigned integer");
        this.mCommission = n;
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxDeclareCandidacy setCoin(String string) {
        this.mCoin = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigDecimal getStake() {
        return new BigDecimal(this.mStake).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxDeclareCandidacy setStake(@Nonnull CharSequence charSequence) {
        return this.setStake(new BigDecimal(charSequence.toString()));
    }

    public TxDeclareCandidacy setStake(BigDecimal bigDecimal) {
        this.mStake = bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    public TxDeclareCandidacy setStake(BigInteger bigInteger) {
        this.mStake = bigInteger;
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.DeclareCandidacy;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        Object object2 = "mAddress";
        boolean bl = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mAddress != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Recipient mAddress must be set");
        object2 = "mPubKey";
        bl = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl, "Node public key must be set");
        object2 = "mCommission";
        Integer n = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCommission;
        boolean bl2 = n != null && n > 0 && ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCommission <= 100;
        object = ((FieldsValidationResult)object).addResult((String)object2, bl2, "Commission must be set (in percents)");
        object2 = "mCoin";
        String string = ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCoin;
        boolean bl3 = string != null && string.length() > 2 && ((TxDeclareCandidacy)((Object)fieldsValidationResult2)).mCoin.length() < 11;
        TxDeclareCandidacy txDeclareCandidacy = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult((String)object2, bl3, "Coin symbol length must be from 3 to 10 chars");
        object = "mStake";
        object2 = txDeclareCandidacy.mStake;
        boolean bl4 = object2 != null && ((BigInteger)object2).compareTo(new BigInteger("0")) > 0;
        return fieldsValidationResult2.addResult((String)object, bl4, "Stake must be set (more than 0)");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mAddress;
        objectArray2[1] = this.mPubKey;
        objectArray2[2] = this.mCommission;
        objectArray2[3] = this.mCoin;
        objectArray[4] = this.mStake;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxDeclareCandidacy txDeclareCandidacy = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txDeclareCandidacy.mAddress = new MinterAddress(this.fromRawRlp(0, objectArray));
        txDeclareCandidacy.mPubKey = new MinterPublicKey(this.fromRawRlp(1, objectArray));
        txDeclareCandidacy.mCommission = BytesHelper.fixBigintSignedByte((char[])txDeclareCandidacy.fromRawRlp(2, objectArray)).intValue();
        txDeclareCandidacy.mCoin = StringHelper.charsToString((char[])txDeclareCandidacy.fromRawRlp(3, objectArray));
        txDeclareCandidacy.mStake = BytesHelper.fixBigintSignedByte((char[])txDeclareCandidacy.fromRawRlp(4, objectArray));
    }
}

