/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCreateCoin
extends Operation {
    public static final Parcelable.Creator<TxCreateCoin> CREATOR = new Parcelable.Creator<TxCreateCoin>(){

        public TxCreateCoin createFromParcel(Parcel parcel) {
            return new TxCreateCoin(parcel);
        }

        public TxCreateCoin[] newArray(int n) {
            return new TxCreateCoin[n];
        }
    };
    private String mName;
    private String mSymbol;
    private BigInteger mInitialAmount;
    private BigInteger mInitialReserve;
    private Integer mConstantReserveRatio;

    public TxCreateCoin() {
    }

    public TxCreateCoin(Transaction transaction) {
        super(transaction);
    }

    protected TxCreateCoin(Parcel object) {
        super((Parcel)object);
        this.mName = object.readString();
        this.mSymbol = object.readString();
        this.mInitialAmount = (BigInteger)object.readValue(BigInteger.class.getClassLoader());
        this.mInitialReserve = (BigInteger)object.readValue(BigInteger.class.getClassLoader());
        object = object.readByte() == 0 ? null : Integer.valueOf(object.readInt());
        this.mConstantReserveRatio = object;
    }

    public static BigInteger calculateCreatingCostBigInteger(String object) {
        Preconditions.checkArgument((((String)object).length() > 2 && ((String)object).length() < 11 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 characters");
        switch (((String)object).length()) {
            default: {
                BigInteger bigInteger;
                object = bigInteger;
                bigInteger = new BigInteger("0");
                break;
            }
            case 8: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("10"));
                break;
            }
            case 7: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("100"));
                break;
            }
            case 6: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("1000"));
                break;
            }
            case 5: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("10000"));
                break;
            }
            case 4: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("100000"));
                break;
            }
            case 3: {
                object = Transaction.VALUE_MUL.multiply(new BigInteger("1000000"));
            }
        }
        return ((BigInteger)object).add(OperationType.CreateCoin.getFee().multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public static BigDecimal calculateCreatingCost(String string) {
        return new BigDecimal(TxCreateCoin.calculateCreatingCostBigInteger(string)).divide(Transaction.VALUE_MUL_DEC);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCreateCoin txCreateCoin = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txCreateCoin.mName);
        parcel.writeString(this.mSymbol);
        parcel.writeValue((Object)this.mInitialAmount);
        parcel.writeValue((Object)this.mInitialReserve);
        if (this.mConstantReserveRatio == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeInt(this.mConstantReserveRatio.intValue());
        }
    }

    public String getName() {
        return this.mName;
    }

    public TxCreateCoin setName(String string) {
        this.mName = string;
        return this;
    }

    public String getSymbol() {
        return this.mSymbol.replace("\u0000", "");
    }

    public TxCreateCoin setSymbol(String string) {
        this.mSymbol = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigDecimal getInitialAmount() {
        return new BigDecimal(this.mInitialAmount).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxCreateCoin setInitialAmount(BigDecimal bigDecimal) {
        return this.setInitialAmount(bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCreateCoin setInitialAmount(BigInteger bigInteger) {
        this.mInitialAmount = bigInteger;
        return this;
    }

    public double getInitialAmountDouble() {
        return this.getInitialAmount().doubleValue();
    }

    public TxCreateCoin setInitialAmount(double d) {
        return this.setInitialAmount(new BigDecimal(String.valueOf(d)));
    }

    public BigDecimal getInitialReserve() {
        return new BigDecimal(this.mInitialReserve).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxCreateCoin setInitialReserve(BigDecimal bigDecimal) {
        return this.setInitialReserve(bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCreateCoin setInitialReserve(BigInteger bigInteger) {
        this.mInitialReserve = bigInteger;
        return this;
    }

    public double getInitialReserveDouble() {
        return this.getInitialReserve().doubleValue();
    }

    public TxCreateCoin setInitialReserve(double d) {
        return this.setInitialReserve(new BigDecimal(String.valueOf(d)));
    }

    public int getConstantReserveRatio() {
        return this.mConstantReserveRatio;
    }

    public TxCreateCoin setConstantReserveRatio(Integer n) {
        Preconditions.checkArgument((n >= 0 && n <= 100 ? 1 : 0) != 0, (Object)"Ratio must be unsigned integer (from 1 to 100%)");
        this.mConstantReserveRatio = n;
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.CreateCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        FieldsValidationResult fieldsValidationResult2 = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mName";
        boolean bl = this.mName != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl, "Coin mName must be set");
        string = "mSymbol";
        String string2 = this.mSymbol;
        boolean bl2 = string2 != null && string2.length() > 2 && this.mSymbol.length() < 11;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Coin mSymbol length must be from 3 to 10 chars");
        string = "mInitialAmount";
        bl2 = this.mInitialAmount != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Initial Amount must be set");
        string = "mInitialReserve";
        bl2 = this.mInitialReserve != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Initial Reserve must be set");
        string = "mConstantReserveRatio";
        bl2 = this.mConstantReserveRatio != null;
        fieldsValidationResult2 = fieldsValidationResult2.addResult(string, bl2, "Reserve ratio must be set");
        string = "mConstantReserveRatio";
        Integer n = this.mConstantReserveRatio;
        boolean bl3 = n != null && n > 1 && this.mConstantReserveRatio <= 100;
        return fieldsValidationResult2.addResult(string, bl3, "Reserve ratio must from 1% to 100%");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mName;
        objectArray2[1] = this.mSymbol;
        objectArray2[2] = this.mInitialAmount;
        objectArray2[3] = this.mInitialReserve;
        objectArray[4] = this.mConstantReserveRatio;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mName = StringHelper.charsToString((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mSymbol = StringHelper.charsToString((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mInitialAmount = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mInitialReserve = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
        objectArray2.mConstantReserveRatio = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(4, objectArray3)).intValue();
    }
}

