/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PublicKey;
import network.minter.core.util.RLPBoxed;

public class TxEditCandidateTransaction
extends Operation {
    public static final Parcelable.Creator<TxEditCandidateTransaction> CREATOR = new Parcelable.Creator<TxEditCandidateTransaction>(){

        public TxEditCandidateTransaction createFromParcel(Parcel parcel) {
            return new TxEditCandidateTransaction(parcel);
        }

        public TxEditCandidateTransaction[] newArray(int n) {
            return new TxEditCandidateTransaction[n];
        }
    };
    private PublicKey mPubKey;
    private MinterAddress mRewardAddress;
    private MinterAddress mOwnerAddress;

    public TxEditCandidateTransaction(@Nonnull Transaction transaction) {
        super(transaction);
    }

    protected TxEditCandidateTransaction(Parcel parcel) {
        super(parcel);
        this.mPubKey = (PublicKey)parcel.readValue(PublicKey.class.getClassLoader());
        this.mRewardAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mOwnerAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
    }

    public TxEditCandidateTransaction setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public PublicKey getPubKey() {
        return this.mPubKey;
    }

    public MinterAddress getRewardAddress() {
        return this.mRewardAddress;
    }

    public TxEditCandidateTransaction setRewardAddress(MinterAddress minterAddress) {
        this.mRewardAddress = minterAddress;
        return this;
    }

    public MinterAddress getOwnerAddress() {
        return this.mOwnerAddress;
    }

    public TxEditCandidateTransaction setOwnerAddress(MinterAddress minterAddress) {
        this.mOwnerAddress = minterAddress;
        return this;
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxEditCandidateTransaction txEditCandidateTransaction = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txEditCandidateTransaction.mPubKey);
        parcel.writeValue((Object)this.mRewardAddress);
        parcel.writeValue((Object)this.mOwnerAddress);
    }

    @Override
    public OperationType getType() {
        return OperationType.EditCandidate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mPubKey";
        boolean bl = ((TxEditCandidateTransaction)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Node public key must be set");
        string = "mRewardAddress";
        bl = ((TxEditCandidateTransaction)((Object)fieldsValidationResult2)).mRewardAddress != null;
        TxEditCandidateTransaction txEditCandidateTransaction = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Reward address must be set");
        object = "mOwnerAddress";
        boolean bl2 = txEditCandidateTransaction.mOwnerAddress != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Owner address must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxEditCandidateTransaction txEditCandidateTransaction = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txEditCandidateTransaction.mPubKey = new PublicKey(this.fromRawRlp(0, objectArray));
        txEditCandidateTransaction.mRewardAddress = new MinterAddress(this.fromRawRlp(1, objectArray));
        txEditCandidateTransaction.mOwnerAddress = new MinterAddress(this.fromRawRlp(2, objectArray));
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mPubKey.getData();
        objectArray2[1] = this.mRewardAddress.getData();
        objectArray[2] = this.mOwnerAddress.getData();
        return RLPBoxed.encode((Object)objectArray);
    }
}

