/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;

public final class TxSendCoin
extends Operation {
    public static final Parcelable.Creator<TxSendCoin> CREATOR = new Parcelable.Creator<TxSendCoin>(){

        public TxSendCoin createFromParcel(Parcel parcel) {
            return new TxSendCoin(parcel);
        }

        public TxSendCoin[] newArray(int n) {
            return new TxSendCoin[n];
        }
    };
    private String mCoin = "MNT";
    private MinterAddress mTo;
    private BigInteger mValue;

    public TxSendCoin(Transaction transaction) {
        super(transaction);
    }

    protected TxSendCoin(Parcel parcel) {
        super(parcel);
        this.mCoin = parcel.readString();
        this.mTo = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mValue = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    private TxSendCoin setValue(BigInteger bigInteger) {
        this.mValue = bigInteger.multiply(Transaction.VALUE_MUL);
        return this;
    }

    public double getValue() {
        return new BigDecimal(this.mValue).divide(Transaction.VALUE_MUL_DEC).doubleValue();
    }

    public String getCoinRaw() {
        return this.mCoin;
    }

    public TxSendCoin setValue(double d) {
        return this.setValue(new BigDecimal(String.valueOf(d)));
    }

    public TxSendCoin setValue(@Nonnull CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        return this.setValue(new BigDecimal(charSequence.toString()));
    }

    public TxSendCoin setValue(BigDecimal bigDecimal) {
        this.mValue = bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxSendCoin txSendCoin = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txSendCoin.mCoin);
        parcel.writeValue((Object)this.mTo);
        parcel.writeValue((Object)this.mValue);
    }

    public BigInteger getValueBigInteger() {
        return this.mValue;
    }

    public MinterAddress getTo() {
        return new MinterAddress(this.mTo);
    }

    public TxSendCoin setTo(CharSequence charSequence) {
        return this.setTo(charSequence.toString());
    }

    public TxSendCoin setTo(MinterAddress minterAddress) {
        this.mTo = minterAddress;
        return this;
    }

    public TxSendCoin setTo(String string) {
        return this.setTo(new MinterAddress((CharSequence)string));
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxSendCoin setCoin(String string) {
        boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid coin passed: %s", objectArray2));
        objectArray2.mCoin = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return objectArray2;
    }

    public TxSendCoin setRawValue(String string, int n) {
        return this.setValue(new BigInteger(string, n));
    }

    @Override
    public OperationType getType() {
        return OperationType.SendCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoin";
        String string2 = ((TxSendCoin)((Object)fieldsValidationResult2)).mCoin;
        boolean bl = string2 != null && string2.length() > 2 && ((TxSendCoin)((Object)fieldsValidationResult2)).mCoin.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin symbol length must be from 3 mTo 10 chars");
        string = "mTo";
        bl = ((TxSendCoin)((Object)fieldsValidationResult2)).mTo != null;
        TxSendCoin txSendCoin = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Recipient address must be set");
        object = "mValue";
        boolean bl2 = txSendCoin.mValue != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Value must be set");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        byte[] byArray = BytesHelper.lpad((int)20, (byte[])this.mTo.getData());
        return RLP.encode((Object)new Object[]{this.mCoin, byArray, this.mValue});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] objectArray) {
        TxSendCoin txSendCoin = this;
        objectArray = (Object[])RLP.decode((byte[])objectArray, (int)0).getDecoded();
        txSendCoin.mCoin = StringHelper.bytesToString((byte[])txSendCoin.fromRawRlp(0, objectArray));
        txSendCoin.mTo = new MinterAddress(this.fromRawRlp(1, objectArray));
        txSendCoin.mValue = BytesHelper.fixBigintSignedByte((byte[])txSendCoin.fromRawRlp(2, objectArray));
    }

    protected void decodeRaw(byte[][] byArray) {
        TxSendCoin txSendCoin = this;
        txSendCoin.mCoin = new String(byArray[0]);
        txSendCoin.mTo = new MinterAddress(byArray[1]);
        this.mValue = BytesHelper.fixBigintSignedByte((byte[])byArray[2]);
    }
}

