/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;

public final class TxCoinSell
extends Operation {
    public static final Parcelable.Creator<TxCoinSell> CREATOR = new Parcelable.Creator<TxCoinSell>(){

        public TxCoinSell createFromParcel(Parcel parcel) {
            return new TxCoinSell(parcel);
        }

        public TxCoinSell[] newArray(int n) {
            return new TxCoinSell[n];
        }
    };
    private String mCoinToSell;
    private BigInteger mValueToSell;
    private String mCoinToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSell(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinSell(Parcel parcel) {
        super(parcel);
        this.mCoinToSell = parcel.readString();
        this.mValueToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinToBuy = parcel.readString();
        this.mMinValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinSell txCoinSell = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txCoinSell.mCoinToSell);
        parcel.writeValue((Object)this.mValueToSell);
        parcel.writeString(this.mCoinToBuy);
        parcel.writeValue((Object)this.mMinValueToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSell setCoinToSell(String string) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSell setCoinToBuy(String string) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigInteger getValueToSellBigInteger() {
        return this.mValueToSell;
    }

    public BigDecimal getValueToSell() {
        return new BigDecimal(this.mValueToSell).divide(Transaction.VALUE_MUL_DEC);
    }

    public double getValueToSellDouble() {
        return this.getValueToSell().doubleValue();
    }

    public TxCoinSell setValueToSell(double d) {
        return this.setValueToSell(new BigDecimal(String.valueOf(d)));
    }

    public TxCoinSell setValueToSell(BigInteger bigInteger) {
        this.mValueToSell = bigInteger;
        return this;
    }

    public TxCoinSell setValueToSell(BigDecimal bigDecimal) {
        return this.setValueToSell(bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCoinSell setMinValueToBuy(double d) {
        return this.setMinValueToBuy(new BigDecimal(String.valueOf(d)));
    }

    public TxCoinSell setMinValueToBuy(BigInteger bigInteger) {
        this.mMinValueToBuy = bigInteger;
        return this;
    }

    public TxCoinSell setMinValueToBuy(BigDecimal bigDecimal) {
        return this.setMinValueToBuy(bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    @Override
    public OperationType getType() {
        return OperationType.SellCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        String string2 = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToBuy;
        boolean bl = string2 != null && string2.length() > 2 && ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToBuy.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin length must be from 3 to 10 chars");
        string = "mCoinToSell";
        String string3 = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToSell;
        boolean bl2 = string3 != null && string3.length() > 2 && ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToSell.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl2, "Coin length must be from 3 to 10 chars");
        string = "mValueToSell";
        bl2 = ((TxCoinSell)((Object)fieldsValidationResult2)).mValueToSell != null;
        TxCoinSell txCoinSell = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl2, "Value must be set");
        object = "mMinValueToBuy";
        boolean bl3 = txCoinSell.mMinValueToBuy != null;
        return fieldsValidationResult2.addResult((String)object, bl3, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinToSell;
        objectArray2[1] = this.mValueToSell;
        objectArray2[2] = this.mCoinToBuy;
        objectArray[3] = this.mMinValueToBuy;
        return RLP.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] byArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLP.decode((byte[])byArray, (int)0).getDecoded();
        objectArray2.mCoinToSell = StringHelper.bytesToString((byte[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mValueToSell = BytesHelper.fixBigintSignedByte((byte[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mCoinToBuy = StringHelper.bytesToString((byte[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mMinValueToBuy = BytesHelper.fixBigintSignedByte((byte[])objectArray.fromRawRlp(3, objectArray3));
    }
}

