/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.util.RLP;

public final class SignatureMultiData
extends SignatureData {
    public static final Parcelable.Creator<SignatureMultiData> CREATOR = new Parcelable.Creator<SignatureMultiData>(){

        public SignatureMultiData createFromParcel(Parcel parcel) {
            return new SignatureMultiData(parcel);
        }

        public SignatureMultiData[] newArray(int n) {
            return new SignatureMultiData[n];
        }
    };
    private MinterAddress mSignatureAddress;
    private List<SignatureSingleData> mSignatures;

    public SignatureMultiData() {
    }

    protected SignatureMultiData(Parcel parcel) {
        this.mSignatureAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        if (parcel.readByte() == 1) {
            this.mSignatures = new ArrayList<SignatureSingleData>();
            parcel.readList(this.mSignatures, SignatureSingleData.class.getClassLoader());
        } else {
            this.mSignatures = null;
        }
    }

    public MinterAddress getSignatureAddress() {
        return this.mSignatureAddress;
    }

    public List<SignatureSingleData> getSignatures() {
        return this.mSignatures;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mSignatureAddress);
        if (this.mSignatures == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeList(this.mSignatures);
        }
    }

    protected void setSigns(MinterAddress minterAddress, List<SignatureSingleData> list) {
        this.mSignatureAddress = minterAddress;
        this.mSignatures = list;
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] objectArray) {
        Object[] objectArray2 = (Object[])RLP.decode((byte[])objectArray, (int)0).getDecoded();
        objectArray = objectArray2;
        this.mSignatureAddress = new MinterAddress(this.fromRawRlp(0, objectArray));
        objectArray = (Object[])objectArray2[1];
        this.mSignatures = new LinkedList<SignatureSingleData>();
        for (int i = 0; i < objectArray.length; ++i) {
            SignatureSingleData signatureSingleData;
            SignatureSingleData signatureSingleData2 = signatureSingleData;
            signatureSingleData2();
            signatureSingleData.decodeRaw(this.objArrToByteArrArr((Object[])objectArray[i]));
            this.mSignatures.add(i, signatureSingleData2);
        }
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        Object[][] objectArrayArray = new Object[this.mSignatures.size()][];
        for (int i = 0; i < this.mSignatures.size(); ++i) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mSignatures.get(i).getV();
            objectArray2[1] = this.mSignatures.get(i).getR();
            objectArray[2] = this.mSignatures.get(i).getS();
            objectArrayArray[i] = objectArray;
        }
        return RLP.encode((Object)new Object[]{this.mSignatureAddress.getData(), objectArrayArray});
    }
}

