/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain;

import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.repo.BlockChainAccountRepository;
import network.minter.blockchain.repo.BlockChainBlockRepository;
import network.minter.blockchain.repo.BlockChainCandidateRepository;
import network.minter.blockchain.repo.BlockChainCoinRepository;
import network.minter.blockchain.repo.BlockChainEventRepository;
import network.minter.blockchain.repo.BlockChainStatusRepository;
import network.minter.blockchain.repo.BlockChainTransactionRepository;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterHashDeserializer;
import network.minter.core.internal.api.converters.MinterPublicKeyDeserializer;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.TimberLogger;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterBlockChainApi {
    private static final String BASE_NODE_URL = "https://minter-node-1.testnet.minter.network:8841";
    private static MinterBlockChainApi INSTANCE;
    private final ApiService.Builder mApiService;
    private BlockChainAccountRepository mAccountRepository;
    private BlockChainCoinRepository mCoinRepository;
    private BlockChainTransactionRepository mTransactionRepository;
    private BlockChainBlockRepository mBlockRepository;
    private BlockChainCandidateRepository mBlockChainCandidateRepository;
    private BlockChainStatusRepository mStatusRepository;
    private BlockChainEventRepository mEventRepository;

    private MinterBlockChainApi() {
        this(BASE_NODE_URL);
    }

    private MinterBlockChainApi(@Nonnull String baseNodeApiUrl) {
        this.mApiService = new ApiService.Builder(baseNodeApiUrl, this.getGsonBuilder());
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.6.0");
    }

    public static void initialize() {
        MinterBlockChainApi.initialize(BASE_NODE_URL, false, (Mint.Leaf)new TimberLogger());
    }

    public static MinterBlockChainApi createInstance(String baseNodeApiUrl, boolean debug, Mint.Leaf logger) {
        if (debug) {
            Mint.brew((Mint.Leaf)logger);
        }
        MinterBlockChainApi api = new MinterBlockChainApi(baseNodeApiUrl);
        api.mApiService.setDebug(debug);
        if (debug) {
            api.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
        return api;
    }

    public static void initialize(String baseNodeApiUrl, boolean debug, Mint.Leaf logger) {
        if (INSTANCE != null) {
            return;
        }
        if (debug) {
            Mint.brew((Mint.Leaf)logger);
        }
        INSTANCE = new MinterBlockChainApi(baseNodeApiUrl);
        MinterBlockChainApi.INSTANCE.mApiService.setDebug(debug);
        if (debug) {
            MinterBlockChainApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(boolean debug) {
        MinterBlockChainApi.initialize(BASE_NODE_URL, debug, (Mint.Leaf)new TimberLogger());
    }

    public static void initialize(String baseNodeApiUrl) {
        MinterBlockChainApi.initialize(baseNodeApiUrl, false, (Mint.Leaf)new TimberLogger());
    }

    public static MinterBlockChainApi getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("You forget to call MinterBlockchainApi.initialize");
        }
        return INSTANCE;
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterHash.class, (Object)new MinterHashDeserializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        out.registerTypeAdapter(MinterPublicKey.class, (Object)new MinterPublicKeyDeserializer());
        return out;
    }

    public BlockChainEventRepository event() {
        if (this.mEventRepository == null) {
            this.mEventRepository = new BlockChainEventRepository(this.mApiService);
        }
        return this.mEventRepository;
    }

    public BlockChainStatusRepository status() {
        if (this.mStatusRepository == null) {
            this.mStatusRepository = new BlockChainStatusRepository(this.mApiService);
        }
        return this.mStatusRepository;
    }

    public BlockChainCandidateRepository candidate() {
        if (this.mBlockChainCandidateRepository == null) {
            this.mBlockChainCandidateRepository = new BlockChainCandidateRepository(this.mApiService);
        }
        return this.mBlockChainCandidateRepository;
    }

    public BlockChainBlockRepository block() {
        if (this.mBlockRepository == null) {
            this.mBlockRepository = new BlockChainBlockRepository(this.mApiService);
        }
        return this.mBlockRepository;
    }

    public BlockChainAccountRepository account() {
        if (this.mAccountRepository == null) {
            this.mAccountRepository = new BlockChainAccountRepository(this.mApiService);
        }
        return this.mAccountRepository;
    }

    public BlockChainTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new BlockChainTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public BlockChainCoinRepository coin() {
        if (this.mCoinRepository == null) {
            this.mCoinRepository = new BlockChainCoinRepository(this.mApiService);
        }
        return this.mCoinRepository;
    }
}

