/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class SignatureSingleData
extends SignatureData {
    public static final Parcelable.Creator<SignatureSingleData> CREATOR = new Parcelable.Creator<SignatureSingleData>(){

        public SignatureSingleData createFromParcel(Parcel in) {
            return new SignatureSingleData(in);
        }

        public SignatureSingleData[] newArray(int size) {
            return new SignatureSingleData[size];
        }
    };
    private BigInteger mV;
    private BigInteger mR;
    private BigInteger mS;

    public SignatureSingleData() {
    }

    protected SignatureSingleData(Parcel in) {
        this.mV = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mR = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mS = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mV);
        dest.writeValue((Object)this.mR);
        dest.writeValue((Object)this.mS);
    }

    public BigInteger getR() {
        return this.mR;
    }

    public BigInteger getS() {
        return this.mS;
    }

    public BigInteger getV() {
        return this.mV;
    }

    protected void setSign(NativeSecp256k1.RecoverableSignature signature) {
        this.mV = new BigInteger(signature.v);
        this.mR = new BigInteger(signature.r);
        this.mS = new BigInteger(signature.s);
    }

    protected void decodeRaw(byte[][] vrs) {
        this.mV = new BigInteger(vrs[0]);
        this.mR = new BigInteger(vrs[1]);
        this.mS = new BigInteger(vrs[2]);
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mV = new BigInteger(this.fromRawRlp(0, decoded));
        this.mR = new BigInteger(this.fromRawRlp(1, decoded));
        this.mS = new BigInteger(this.fromRawRlp(2, decoded));
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mV, this.mR, this.mS});
    }
}

