/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import network.minter.blockchain.MinterBlockChainApi;
import network.minter.blockchain.api.BlockChainTransactionEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.HistoryTransaction;
import network.minter.blockchain.models.TransactionCommissionValue;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainTransactionRepository
extends DataRepository<BlockChainTransactionEndpoint>
implements DataRepository.Configurator {
    public BlockChainTransactionRepository(@Nonnull ApiService.Builder apiBuilder) {
        super(apiBuilder);
    }

    public Call<BCResult<List<HistoryTransaction>>> getTransactions(@Nonnull TQuery query) {
        return ((BlockChainTransactionEndpoint)this.getInstantService(this)).getTransactions(((TQuery)Preconditions.checkNotNull((Object)query, (String)"Query required")).build());
    }

    public Call<BCResult<HistoryTransaction>> getTransaction(MinterHash hash) {
        return this.getTransaction(hash.toString());
    }

    public Call<BCResult<HistoryTransaction>> getTransaction(String txHash) {
        return ((BlockChainTransactionEndpoint)this.getInstantService(this)).getTransaction(txHash);
    }

    public void configure(ApiService.Builder api) {
        api.registerTypeAdapter(HistoryTransaction.class, (Object)new HistoryTransactionDeserializer());
    }

    public Call<BCResult<TransactionCommissionValue>> getTransactionCommission(TransactionSign sign) {
        return this.getTransactionCommission(sign.getTxSign());
    }

    public Call<BCResult<TransactionCommissionValue>> getTransactionCommission(String sign) {
        return ((BlockChainTransactionEndpoint)this.getInstantService()).getTxCommission(sign);
    }

    @Nonnull
    protected Class<BlockChainTransactionEndpoint> getServiceClass() {
        return BlockChainTransactionEndpoint.class;
    }

    public static class TQuery {
        private final Map<String, String> mData = new HashMap<String, String>();

        public TQuery setFrom(MinterAddress from) {
            return this.setFrom(from.toString());
        }

        public TQuery setTo(MinterAddress to) {
            return this.setTo(to.toString());
        }

        public TQuery setTo(String to) {
            this.mData.put("tx.to", this.normalizeAddress(to));
            return this;
        }

        public TQuery setFrom(String from) {
            this.mData.put("tx.from", this.normalizeAddress(from));
            return this;
        }

        public String build() {
            StringBuilder out = new StringBuilder();
            int i = 0;
            for (Map.Entry<String, String> v : this.mData.entrySet()) {
                out.append(v.getKey()).append("=").append("'").append(v.getValue()).append("'");
                if (i + 1 >= this.mData.size()) continue;
                out.append('&');
            }
            return out.toString();
        }

        private String normalizeAddress(String in) {
            String prefix = in.substring(0, 2);
            if (prefix.equals("Mx") || prefix.equals("Mx".toLowerCase()) || prefix.equals("0x")) {
                return in.substring(2);
            }
            return in;
        }
    }

    public static final class HistoryTransactionDeserializer
    implements JsonDeserializer<HistoryTransaction> {
        public HistoryTransaction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull() || !json.isJsonObject()) {
                return null;
            }
            Gson gson = MinterBlockChainApi.getInstance().getGsonBuilder().create();
            HistoryTransaction out = (HistoryTransaction)gson.fromJson(json, HistoryTransaction.class);
            out.data = gson.fromJson((JsonElement)json.getAsJsonObject().get("data").getAsJsonObject(), out.type.getOpClass());
            return out;
        }
    }
}

