/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PublicKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxDeclareCandidacy
extends Operation {
    public static final Parcelable.Creator<TxDeclareCandidacy> CREATOR = new Parcelable.Creator<TxDeclareCandidacy>(){

        public TxDeclareCandidacy createFromParcel(Parcel in) {
            return new TxDeclareCandidacy(in);
        }

        public TxDeclareCandidacy[] newArray(int size) {
            return new TxDeclareCandidacy[size];
        }
    };
    private MinterAddress mAddress;
    private PublicKey mPubKey;
    private Integer mCommission;
    private String mCoin;
    private BigInteger mStake;

    public TxDeclareCandidacy(Transaction rawTx) {
        super(rawTx);
    }

    protected TxDeclareCandidacy(Parcel in) {
        super(in);
        this.mAddress = (MinterAddress)in.readValue(MinterAddress.class.getClassLoader());
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
        this.mCommission = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        this.mCoin = in.readString();
        this.mStake = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mAddress);
        dest.writeValue((Object)this.mPubKey);
        if (this.mCommission == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.mCommission.intValue());
        }
        dest.writeString(this.mCoin);
        dest.writeValue((Object)this.mStake);
    }

    public MinterAddress getAddress() {
        return this.mAddress;
    }

    public TxDeclareCandidacy setAddress(String address) {
        this.mAddress = new MinterAddress((CharSequence)address);
        return this;
    }

    public TxDeclareCandidacy setAddress(MinterAddress address) {
        this.mAddress = address;
        return this;
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDeclareCandidacy setPublicKey(String hexPubKey) {
        this.mPubKey = new PublicKey((CharSequence)hexPubKey);
        return this;
    }

    public TxDeclareCandidacy setPublicKey(byte[] publicKey) {
        this.mPubKey = new PublicKey(publicKey);
        return this;
    }

    public TxDeclareCandidacy setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public int getCommission() {
        return this.mCommission;
    }

    public TxDeclareCandidacy setCommission(Integer commission) {
        Preconditions.checkArgument((commission >= 0 ? 1 : 0) != 0, (Object)"Commission must be unsigned integer");
        this.mCommission = commission;
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxDeclareCandidacy setCoin(String coinName) {
        this.mCoin = StringHelper.strrpad((int)10, (String)coinName.toUpperCase());
        return this;
    }

    public BigDecimal getStake() {
        return new BigDecimal(this.mStake).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxDeclareCandidacy setStake(String stakeBigInteger) {
        this.mStake = new BigInteger(stakeBigInteger);
        return this;
    }

    public double getStakeDouble() {
        return this.getStake().doubleValue();
    }

    public TxDeclareCandidacy setStake(BigDecimal stakeDecimal) {
        this.mStake = stakeDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    public TxDeclareCandidacy setStake(BigInteger stakeBigInteger) {
        this.mStake = stakeBigInteger;
        return this;
    }

    public TxDeclareCandidacy setStake(double amount) {
        return this.setStake(new BigDecimal(amount));
    }

    @Override
    public OperationType getType() {
        return OperationType.DeclareCandidacy;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mAddress", this.mAddress != null, "Recipient mAddress must be set").addResult("mPubKey", this.mPubKey != null, "Node public key must be set").addResult("mCommission", this.mCommission != null && this.mCommission > 0 && this.mCommission <= 100, "Commission must be set (in percents)").addResult("mCoin", this.mCoin != null && this.mCoin.length() > 2 && this.mCoin.length() < 11, "Coin symbol length must be from 3 to 10 chars").addResult("mStake", this.mStake != null && this.mStake.compareTo(new BigInteger("0")) > 0, "Stake must be set (more than 0)");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mAddress.getData(), this.mPubKey.getData(), this.mCommission, this.mCoin, this.mStake});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mAddress = new MinterAddress(this.fromRawRlp(0, decoded));
        this.mPubKey = new PublicKey(this.fromRawRlp(1, decoded));
        this.mCommission = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded)).intValue();
        this.mCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(3, decoded));
        this.mStake = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(4, decoded));
    }
}

