/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.HashUtil;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;

public class CheckTransaction {
    private String mPassphrase;
    private BigInteger mNonce;
    private BigInteger mDueBlock;
    private String mCoin = "MNT";
    private BigInteger mValue;
    private BytesData mLock;
    private SignatureSingleData mSignature;

    CheckTransaction(BigInteger nonce, String passphrase) {
        this.mNonce = nonce;
        this.mPassphrase = passphrase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesData makeProof(MinterAddress address, String passphrase) {
        NativeSecp256k1.RecoverableSignature signature;
        BytesData key = new BytesData(HashUtil.sha256((byte[])passphrase.getBytes()));
        BytesData encodedAddress = new BytesData(RLP.encode((Object)new Object[]{address.getData()})).sha3Mutable();
        long ctx = NativeSecp256k1.contextCreate();
        try {
            signature = NativeSecp256k1.signRecoverableSerialized((long)ctx, (byte[])encodedAddress.getData(), (byte[])key.getData());
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx);
        }
        if (signature.v[0] != 1) {
            signature.v[0] = 0;
        }
        return new BytesData((byte[][])new byte[][]{signature.r, signature.s, signature.v});
    }

    public void cleanup() {
        this.mPassphrase = null;
        this.mNonce = null;
        this.mDueBlock = null;
        this.mCoin = null;
        this.mValue = null;
        this.mLock = null;
        this.mSignature = null;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getDueBlock() {
        return this.mDueBlock;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public SignatureSingleData getSignature() {
        return this.mSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSign sign(PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature rsv;
        NativeSecp256k1.RecoverableSignature lockSig;
        BytesData hashBytes = new BytesData(this.encode(true));
        BytesData hash = hashBytes.sha3Data();
        BytesData pk = new BytesData(this.mPassphrase.getBytes()).sha256Mutable();
        long ctx = NativeSecp256k1.contextCreate();
        try {
            lockSig = NativeSecp256k1.signRecoverableSerialized((long)ctx, (byte[])hash.getData(), (byte[])pk.getData());
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx);
        }
        if (lockSig.v[0] != 1) {
            lockSig.v[0] = 0;
        }
        this.mLock = new BytesData((byte[][])new byte[][]{lockSig.r, lockSig.s, lockSig.v});
        BytesData withLock = new BytesData(this.encode(false)).sha3Mutable();
        long ctx2 = NativeSecp256k1.contextCreate();
        try {
            rsv = NativeSecp256k1.signRecoverableSerialized((long)ctx2, (byte[])withLock.getData(), (byte[])privateKey.getData());
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx2);
        }
        this.mSignature = new SignatureSingleData();
        this.mSignature.setSign(rsv);
        String signedCheck = new BytesData(this.encode(false)).toHexString("Mc");
        return new TransactionSign(signedCheck);
    }

    private byte[] encode(boolean forSigning) {
        if (forSigning) {
            return RLP.encode((Object)new Object[]{this.mNonce, this.mDueBlock, this.mCoin, this.mValue});
        }
        byte[] lock = this.mLock.getData();
        if (this.mSignature != null && this.mSignature.getV() != null && this.mSignature.getR() != null && this.mSignature.getS() != null) {
            return RLP.encode((Object)new Object[]{this.mNonce, this.mDueBlock, this.mCoin, this.mValue, lock, this.mSignature.getV(), this.mSignature.getR(), this.mSignature.getS()});
        }
        return RLP.encode((Object)new Object[]{this.mNonce, this.mDueBlock, this.mCoin, this.mValue, lock});
    }

    public static final class Builder {
        private CheckTransaction mCheck;

        public Builder(BigInteger nonce, String passphrase) {
            this.mCheck = new CheckTransaction(nonce, passphrase);
        }

        public Builder setCoin(String coin) {
            Preconditions.checkArgument((coin != null && coin.length() >= 3 && coin.length() <= 10 ? 1 : 0) != 0, (Object)String.format("Invalid coin passed: %s", coin));
            this.mCheck.mCoin = StringHelper.strrpad((int)10, (String)coin);
            return this;
        }

        public Builder setValue(BigDecimal value) {
            this.mCheck.mValue = value.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
            return this;
        }

        public Builder setValue(double value) {
            return this.setValue(new BigDecimal(value));
        }

        public Builder setDueBlock(BigInteger dueBlockNum) {
            this.mCheck.mDueBlock = dueBlockNum;
            return this;
        }

        public CheckTransaction build() {
            Preconditions.checkNotNull((Object)this.mCheck.mValue, (String)"Value must be set");
            Preconditions.checkNotNull((Object)this.mCheck.mDueBlock, (String)"Due block must be set");
            Preconditions.checkNotNull((Object)this.mCheck.mNonce, (String)"Nonce required");
            Preconditions.checkNotNull((Object)this.mCheck.mPassphrase, (String)"Passphrase required");
            return this.mCheck;
        }
    }
}

