/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxSetCandidateOffline
extends Operation {
    public static final Parcelable.Creator<TxSetCandidateOffline> CREATOR = new Parcelable.Creator<TxSetCandidateOffline>(){

        public TxSetCandidateOffline createFromParcel(Parcel in) {
            return new TxSetCandidateOffline(in);
        }

        public TxSetCandidateOffline[] newArray(int size) {
            return new TxSetCandidateOffline[size];
        }
    };
    private PublicKey mPubKey;

    public TxSetCandidateOffline(Transaction rawTx) {
        super(rawTx);
    }

    protected TxSetCandidateOffline(Parcel in) {
        super(in);
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxSetCandidateOffline setPublicKey(byte[] publicKey) {
        this.mPubKey = new PublicKey(publicKey);
        return this;
    }

    public TxSetCandidateOffline setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public TxSetCandidateOffline setPublicKey(String hexPubKey) {
        this.mPubKey = new PublicKey((CharSequence)hexPubKey);
        return this;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mPubKey);
    }

    @Override
    public OperationType getType() {
        return OperationType.SetCandidateOffline;
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mPubKey.getData()});
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mPubKey", this.mPubKey != null, "Node public key must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mPubKey = new PublicKey(this.fromRawRlp(0, decoded));
    }
}

