/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxCreateCoin
extends Operation {
    public static final Parcelable.Creator<TxCreateCoin> CREATOR = new Parcelable.Creator<TxCreateCoin>(){

        public TxCreateCoin createFromParcel(Parcel in) {
            return new TxCreateCoin(in);
        }

        public TxCreateCoin[] newArray(int size) {
            return new TxCreateCoin[size];
        }
    };
    private String mName;
    private String mSymbol;
    private BigInteger mInitialAmount;
    private BigInteger mInitialReserve;
    private Integer mConstantReserveRatio;

    public TxCreateCoin(Transaction rawTx) {
        super(rawTx);
    }

    protected TxCreateCoin(Parcel in) {
        super(in);
        this.mName = in.readString();
        this.mSymbol = in.readString();
        this.mInitialAmount = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mInitialReserve = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mConstantReserveRatio = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
    }

    public static BigInteger calculateCreatingCostBigInteger(String coin) {
        BigInteger out;
        Preconditions.checkArgument((coin.length() > 2 && coin.length() < 11 ? 1 : 0) != 0, (Object)"Coin length must be from 3 to 10 characters");
        switch (coin.length()) {
            case 3: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("1000000"));
                break;
            }
            case 4: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("100000"));
                break;
            }
            case 5: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("10000"));
                break;
            }
            case 6: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("1000"));
                break;
            }
            case 7: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("100"));
                break;
            }
            case 8: {
                out = Transaction.VALUE_MUL.multiply(new BigInteger("10"));
                break;
            }
            default: {
                out = new BigInteger("0");
            }
        }
        return out.add(OperationType.CreateCoin.getFee().multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public static BigDecimal calculateCreatingCost(String coin) {
        return new BigDecimal(TxCreateCoin.calculateCreatingCostBigInteger(coin)).divide(Transaction.VALUE_MUL_DEC);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mName);
        dest.writeString(this.mSymbol);
        dest.writeValue((Object)this.mInitialAmount);
        dest.writeValue((Object)this.mInitialReserve);
        if (this.mConstantReserveRatio == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.mConstantReserveRatio.intValue());
        }
    }

    public String getName() {
        return this.mName;
    }

    public TxCreateCoin setName(String name) {
        this.mName = name;
        return this;
    }

    public String getSymbol() {
        return this.mSymbol.replace("\u0000", "");
    }

    public TxCreateCoin setSymbol(String coinName) {
        this.mSymbol = StringHelper.strrpad((int)10, (String)coinName.toUpperCase());
        return this;
    }

    public BigDecimal getInitialAmount() {
        return new BigDecimal(this.mInitialAmount).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxCreateCoin setInitialAmount(BigDecimal amount) {
        return this.setInitialAmount(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCreateCoin setInitialAmount(BigInteger amount) {
        this.mInitialAmount = amount;
        return this;
    }

    public double getInitialAmountDouble() {
        return this.getInitialAmount().doubleValue();
    }

    public TxCreateCoin setInitialAmount(double amount) {
        return this.setInitialAmount(new BigDecimal(amount));
    }

    public BigDecimal getInitialReserve() {
        return new BigDecimal(this.mInitialReserve).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxCreateCoin setInitialReserve(BigDecimal amount) {
        return this.setInitialReserve(amount.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
    }

    public TxCreateCoin setInitialReserve(BigInteger amount) {
        this.mInitialReserve = amount;
        return this;
    }

    public double getInitialReserveDouble() {
        return this.getInitialReserve().doubleValue();
    }

    public TxCreateCoin setInitialReserve(double amount) {
        return this.setInitialReserve(new BigDecimal(amount));
    }

    public int getConstantReserveRatio() {
        return this.mConstantReserveRatio;
    }

    public TxCreateCoin setConstantReserveRatio(Integer ratio) {
        Preconditions.checkArgument((ratio >= 0 && ratio <= 100 ? 1 : 0) != 0, (Object)"Ratio must be unsigned integer (from 1 to 100%)");
        this.mConstantReserveRatio = ratio;
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.CreateCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mName", this.mName != null, "Coin mName must be set").addResult("mSymbol", this.mSymbol != null && this.mSymbol.length() > 2 && this.mSymbol.length() < 11, "Coin mSymbol length must be from 3 to 10 chars").addResult("mInitialAmount", this.mInitialAmount != null, "Initial Amount must be set").addResult("mInitialReserve", this.mInitialReserve != null, "Initial Reserve must be set").addResult("mConstantReserveRatio", this.mConstantReserveRatio != null, "Reserve ratio must be set").addResult("mConstantReserveRatio", this.mConstantReserveRatio != null && this.mConstantReserveRatio > 1 && this.mConstantReserveRatio <= 100, "Reserve ratio must from 1% to 100%");
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mName, this.mSymbol, this.mInitialAmount, this.mInitialReserve, this.mConstantReserveRatio});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mName = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mSymbol = StringHelper.bytesToString((byte[])this.fromRawRlp(1, decoded));
        this.mInitialAmount = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded));
        this.mInitialReserve = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(3, decoded));
        this.mConstantReserveRatio = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(4, decoded)).intValue();
    }
}

