/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.RLPSerializable;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.common.Preconditions;

public abstract class Operation
extends RLPSerializable
implements Parcelable {
    private final Transaction mTx;

    public Operation() {
        this.mTx = null;
    }

    public Operation(@Nonnull Transaction transaction) {
        this.mTx = transaction;
    }

    protected Operation(Parcel parcel) {
        this.mTx = (Transaction)parcel.readValue(Transaction.class.getClassLoader());
    }

    public Transaction build() throws OperationInvalidDataException {
        Object object = ((Operation)object2).mTx;
        if (((Operation)object2).mTx != null) {
            object = object.setData(object2);
            Object[] objectArray = ((Operation)object2).validate();
            if (objectArray == null) {
                objectArray = object.validate();
            } else {
                objectArray.addResult(object.validate());
            }
            if (objectArray != null && !objectArray.isValid()) {
                Object[] objectArray2 = new String[1];
                Object[] objectArray3 = new Object[1];
                object = objectArray3;
                objectArray3[0] = ((Operation)object2).getType().name();
                objectArray2[0] = String.format("Invalid %s operation data", object);
                Object object2 = (String)Preconditions.firstNonNull((Object)objectArray.getTitle(), (Object[])objectArray2);
                object = objectArray.getInvalidFieldsMessages();
                Object[] objectArray4 = objectArray;
                Object[] objectArray5 = new Object[2];
                objectArray = objectArray5;
                objectArray5[0] = object2;
                objectArray5[1] = object;
                object2 = String.format("%s\nInvalid fields:\n%s", objectArray);
                throw new OperationInvalidDataException((String)object2, objectArray4.getFieldMessageMap());
            }
            return object;
        }
        throw new OperationInvalidDataException("Can't build operation, because transaction isn't passed", Collections.emptyList());
    }

    public abstract OperationType getType();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mTx);
    }

    @Nullable
    protected abstract FieldsValidationResult validate();

    protected Transaction getTx() {
        return this.mTx;
    }
}

