/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.InvalidEncodedTransactionException;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public class ExternalTransaction
implements Parcelable {
    public static final Parcelable.Creator<ExternalTransaction> CREATOR = new Parcelable.Creator<ExternalTransaction>(){

        public ExternalTransaction createFromParcel(Parcel parcel) {
            return new ExternalTransaction(parcel);
        }

        public ExternalTransaction[] newArray(int n) {
            return new ExternalTransaction[n];
        }
    };
    OperationType mType = OperationType.SendCoin;
    Operation mOperationData;
    BytesData mPayload = new BytesData(new char[0]);
    BigInteger mNonce;
    BigInteger mGasPrice;
    String mGasCoin = "MNT";

    public ExternalTransaction(Transaction transaction) {
        this.mNonce = transaction.mNonce;
        this.mGasPrice = transaction.mGasPrice;
        this.mGasCoin = transaction.mGasCoin;
        this.mType = transaction.mType;
        this.mOperationData = transaction.mOperationData;
        this.mPayload = transaction.mPayload;
    }

    protected ExternalTransaction(Parcel parcel) {
        this.mType = (OperationType)((Object)parcel.readValue(OperationType.class.getClassLoader()));
        this.mOperationData = (Operation)parcel.readValue(Operation.class.getClassLoader());
        this.mPayload = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mNonce = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mGasPrice = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mGasCoin = parcel.readString();
    }

    protected ExternalTransaction() {
    }

    public static ExternalTransaction fromEncoded(@Nonnull String objectArray) {
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new BytesData((CharSequence)objectArray).getData(), (int)0).getDecoded();
        if (objectArray.length >= 6) {
            Operation operation;
            ExternalTransaction externalTransaction;
            ExternalTransaction externalTransaction2 = externalTransaction;
            externalTransaction2();
            externalTransaction.decodeRLP(objectArray);
            try {
                operation = externalTransaction.mType.getOpClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throw new InvalidEncodedTransactionException("Unable to decode transaction data field", throwable);
            }
            externalTransaction2.mOperationData = operation;
            operation.decodeRLP(externalTransaction2.fromRawRlp(1, objectArray));
            return externalTransaction;
        }
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray.length;
        throw new InvalidEncodedTransactionException("Encoded transaction has invalid data length: expected 6, given %d", objectArray3);
    }

    public Transaction toTransaction() throws OperationInvalidDataException {
        return new Transaction.Builder(this.mNonce).setGasCoin(this.mGasCoin).setGasPrice(this.mGasPrice).setPayload(this.mPayload).setData(this.mOperationData).build();
    }

    public BytesData encode() {
        BigInteger bigInteger;
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = objectArray;
        ExternalTransaction externalTransaction = object;
        objectArray2[0] = ((ExternalTransaction)object).mOperationData.getType().getValue();
        objectArray2[1] = ((ExternalTransaction)object).mOperationData.encodeRLP();
        objectArray2[2] = ((ExternalTransaction)object).mPayload.getData();
        objectArray2[3] = Preconditions.firstNonNull((Object)((ExternalTransaction)object).mNonce, (Object[])new BigInteger[]{BigInteger.ZERO});
        Object[] objectArray3 = new BigInteger[1];
        Object object = bigInteger;
        bigInteger = new BigInteger("1");
        objectArray3[0] = object;
        objectArray2[4] = Preconditions.firstNonNull((Object)((ExternalTransaction)object).mGasPrice, (Object[])objectArray3);
        objectArray[5] = Preconditions.firstNonNull((Object)StringHelper.strrpad((int)10, (String)externalTransaction.mGasCoin), (Object[])new String[]{""});
        object = RLPBoxed.encode((Object)objectArray);
        return new BytesData((char[])object);
    }

    public OperationType getType() {
        return this.mType;
    }

    public String getGasCoin() {
        return this.mGasCoin.replace("\u0000", "");
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getGasPrice() {
        return this.mGasPrice;
    }

    public <OpType extends Operation> OpType getData() {
        return (OpType)this.mOperationData;
    }

    public <OpType extends Operation> OpType getData(Class<OpType> clazz) {
        return (OpType)((Operation)clazz.cast(this.mOperationData));
    }

    public BytesData getPayload() {
        return this.mPayload;
    }

    public String getPayloadString() {
        return new String(this.getPayload().getData());
    }

    public void cleanup() {
        ExternalTransaction externalTransaction = this;
        externalTransaction.mNonce = null;
        externalTransaction.mGasPrice = null;
        externalTransaction.mGasCoin = null;
        externalTransaction.mType = null;
        externalTransaction.mOperationData = null;
        externalTransaction.mPayload = null;
    }

    public void resetPayload(BytesData bytesData) {
        Preconditions.checkArgument((bytesData.size() <= 1024 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes");
        this.mPayload = bytesData;
    }

    public <Op extends Operation> void resetData(Op Op) {
        ((ExternalTransaction)((Object)fieldsValidationResult)).mType = Op.getType();
        ((ExternalTransaction)((Object)fieldsValidationResult)).mOperationData = Op;
        FieldsValidationResult fieldsValidationResult = Op.validate();
        if (fieldsValidationResult != null) {
            Preconditions.checkArgument((boolean)fieldsValidationResult.isValid(), (Object)fieldsValidationResult.getInvalidFieldsMessages());
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mType);
        parcel.writeValue((Object)this.mOperationData);
        parcel.writeValue((Object)this.mPayload);
        parcel.writeValue((Object)this.mNonce);
        parcel.writeValue((Object)this.mGasPrice);
        parcel.writeString(this.mGasCoin);
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    void decodeRLP(Object[] objectArray) {
        ExternalTransaction externalTransaction = this;
        externalTransaction.mType = OperationType.findByValue(new BigInteger(BytesHelper.charsToBytes((char[])this.fromRawRlp(0, objectArray))));
        externalTransaction.mPayload = new BytesData(this.fromRawRlp(2, objectArray));
        this.mNonce = BytesHelper.fixBigintSignedByte((Object)objectArray[3]);
        this.mGasPrice = BytesHelper.fixBigintSignedByte((Object)objectArray[4]);
        this.mGasCoin = StringHelper.charsToString((char[])this.fromRawRlp(5, objectArray));
    }

    public static class Builder {
        private final ExternalTransaction mTx;

        public Builder() {
            ExternalTransaction externalTransaction;
            ExternalTransaction externalTransaction2 = externalTransaction;
            externalTransaction = new ExternalTransaction();
            v1.mTx = externalTransaction2;
        }

        public Builder setNonce(BigInteger bigInteger) {
            this.mTx.mNonce = bigInteger;
            return this;
        }

        public Builder setGasPrice(BigInteger bigInteger) {
            this.mTx.mGasPrice = bigInteger;
            return this;
        }

        public Builder setGasCoin(String string) {
            this.mTx.mGasCoin = StringHelper.strrpad((int)10, (String)string);
            return this;
        }

        public Builder setPayload(byte[] byArray) {
            return this.setPayload(new BytesData(byArray, true));
        }

        public Builder setPayload(BytesData bytesData) {
            Preconditions.checkArgument((bytesData.size() <= 1024 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes");
            this.mTx.mPayload = new BytesData(bytesData.getData(), true);
            return this;
        }

        public Builder setPayload(@Nonnull String string) {
            String string2 = string;
            Preconditions.checkNotNull((Object)string2, (String)"Hex data string can't be null");
            Preconditions.checkArgument((string2.length() <= 2048 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes (2048 in hex string)");
            this.mTx.mPayload = new BytesData((CharSequence)string);
            return this;
        }

        public Builder setPayload(ByteBuffer byteBuffer) {
            return this.setPayload(byteBuffer.array());
        }

        public <Op extends Operation> Builder setData(Op object) {
            Builder builder = this;
            builder.mTx.mType = ((Operation)object).getType();
            builder.mTx.mOperationData = object;
            if ((object = ((Operation)object).validate()) != null) {
                Preconditions.checkArgument((boolean)((FieldsValidationResult)object).isValid(), (Object)((FieldsValidationResult)object).getInvalidFieldsMessages());
            }
            return this;
        }

        public ExternalTransaction build() {
            return this.mTx;
        }
    }
}

