/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;

public class BCResult<Result> {
    public int statusCode = 200;
    @SerializedName(value="result")
    public Result result;
    public ErrorResult error;

    public static <T> BCResult<T> copyError(BCResult<?> bCResult) {
        BCResult bCResult2;
        BCResult bCResult3 = bCResult2;
        bCResult3();
        bCResult3.statusCode = bCResult.statusCode;
        bCResult2.error = bCResult.error;
        return bCResult2;
    }

    public boolean isOk() {
        return this.error == null && this.result != null;
    }

    @Nonnull
    public String toString() {
        String string = "BCResult{code=%s, result=%s, message=%s}";
        Object[] objectArray = new Object[3];
        int n = 0;
        Object object = this.error;
        object = object != null ? ((ErrorResult)object).getResultCode().name() : "{no error code}";
        objectArray[n] = object;
        n = 1;
        object = this.result != null ? "{has result: " + this.result.getClass().getName() + "}" : "null";
        objectArray[n] = object;
        int n2 = 2;
        Object object2 = this.error;
        object2 = object2 != null ? ((ErrorResult)object2).getMessage() : "null";
        objectArray[n2] = object2;
        return String.format(string, objectArray);
    }

    @Deprecated
    public boolean isSuccess() {
        return this.statusCode == 200 && this.error == null;
    }

    public static final class ErrorResult {
        public int code;
        public String message;
        public String data;

        public ResultCode getResultCode() {
            return ResultCode.findByCode(this.code);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            String string = this.data;
            if (string != null && !string.isEmpty()) {
                return this.data;
            }
            return this.message;
        }
    }

    public static final class ResultCode
    extends Enum<ResultCode> {
        public static final /* enum */ ResultCode UnknownError;
        @Deprecated
        public static final /* enum */ ResultCode Success;
        @SerializedName(value="101")
        public static final /* enum */ ResultCode WrongNonce;
        @SerializedName(value="102")
        public static final /* enum */ ResultCode CoinNotExists;
        @SerializedName(value="103")
        public static final /* enum */ ResultCode CoinReserveNotSufficient;
        @SerializedName(value="105")
        public static final /* enum */ ResultCode TxTooLarge;
        @SerializedName(value="106")
        public static final /* enum */ ResultCode DecodeError;
        @SerializedName(value="107")
        public static final /* enum */ ResultCode InsufficientFunds;
        @SerializedName(value="109")
        public static final /* enum */ ResultCode TxPayloadTooLarge;
        @SerializedName(value="110")
        public static final /* enum */ ResultCode TxServiceDataTooLarge;
        @SerializedName(value="110")
        public static final /* enum */ ResultCode InvalidMultisendData;
        @SerializedName(value="112")
        public static final /* enum */ ResultCode CoinSupplyOverflow;
        @SerializedName(value="113")
        public static final /* enum */ ResultCode TxFromSenderAlreadyInMempool;
        @SerializedName(value="114")
        public static final /* enum */ ResultCode TooLowGasPrice;
        @SerializedName(value="115")
        public static final /* enum */ ResultCode WrongChainId;
        @SerializedName(value="201")
        public static final /* enum */ ResultCode CoinAlreadyExists;
        @SerializedName(value="202")
        public static final /* enum */ ResultCode WrongCrr;
        @SerializedName(value="203")
        public static final /* enum */ ResultCode InvalidCoinSymbol;
        @SerializedName(value="204")
        public static final /* enum */ ResultCode InvalidCoinName;
        @SerializedName(value="204")
        public static final /* enum */ ResultCode WrongCoinSupply;
        @SerializedName(value="301")
        public static final /* enum */ ResultCode CrossConvert;
        @SerializedName(value="302")
        public static final /* enum */ ResultCode MaximumValueToSellReached;
        @SerializedName(value="303")
        public static final /* enum */ ResultCode MinimumValueToBuylReached;
        @SerializedName(value="401")
        public static final /* enum */ ResultCode CandidateExists;
        @SerializedName(value="402")
        public static final /* enum */ ResultCode WrongCommission;
        @SerializedName(value="403")
        public static final /* enum */ ResultCode CandidateNotFound;
        @SerializedName(value="404")
        public static final /* enum */ ResultCode StakeNotFound;
        @SerializedName(value="405")
        public static final /* enum */ ResultCode InsufficientStake;
        @SerializedName(value="406")
        public static final /* enum */ ResultCode IsNotOwnerOfCandidate;
        @SerializedName(value="407")
        public static final /* enum */ ResultCode IncorrectPubKey;
        @SerializedName(value="408")
        public static final /* enum */ ResultCode StakeShouldBePositive;
        @SerializedName(value="409")
        public static final /* enum */ ResultCode TooLowStake;
        @SerializedName(value="501")
        public static final /* enum */ ResultCode CheckInvalidLock;
        @SerializedName(value="502")
        public static final /* enum */ ResultCode CheckExpired;
        @SerializedName(value="503")
        public static final /* enum */ ResultCode CheckUsed;
        @SerializedName(value="504")
        public static final /* enum */ ResultCode TooHighGasPrice;
        @SerializedName(value="505")
        public static final /* enum */ ResultCode WrongGasCoin;
        @SerializedName(value="601")
        public static final /* enum */ ResultCode IncorrectWeights;
        @SerializedName(value="602")
        public static final /* enum */ ResultCode MultisigExists;
        @SerializedName(value="603")
        public static final /* enum */ ResultCode MultisigNotExists;
        @SerializedName(value="604")
        public static final /* enum */ ResultCode IncorrectMultiSignature;
        @SerializedName(value="605")
        public static final /* enum */ ResultCode TooLargeOwnersList;
        private static final /* synthetic */ ResultCode[] $VALUES;
        final int resVal;

        public static ResultCode[] values() {
            return (ResultCode[])$VALUES.clone();
        }

        public static ResultCode valueOf(String string) {
            return Enum.valueOf(ResultCode.class, string);
        }

        private ResultCode(int n2) {
            this.resVal = n2;
        }

        public static boolean isKnownError(int n) {
            ResultCode[] resultCodeArray = ResultCode.values();
            int n2 = resultCodeArray.length;
            for (int i = 0; i < n2; ++i) {
                if (n != resultCodeArray[i].getValue()) continue;
                return true;
            }
            return false;
        }

        public static ResultCode findByCode(int n) {
            for (ResultCode resultCode : ResultCode.values()) {
                if (n != resultCode.getValue()) continue;
                return resultCode;
            }
            return UnknownError;
        }

        static {
            ResultCode resultCode;
            UnknownError = new ResultCode(-1);
            Success = new ResultCode(0);
            WrongNonce = new ResultCode(101);
            CoinNotExists = new ResultCode(102);
            CoinReserveNotSufficient = new ResultCode(103);
            TxTooLarge = new ResultCode(105);
            DecodeError = new ResultCode(106);
            InsufficientFunds = new ResultCode(107);
            TxPayloadTooLarge = new ResultCode(109);
            TxServiceDataTooLarge = new ResultCode(110);
            InvalidMultisendData = new ResultCode(111);
            CoinSupplyOverflow = new ResultCode(112);
            TxFromSenderAlreadyInMempool = new ResultCode(113);
            TooLowGasPrice = new ResultCode(114);
            WrongChainId = new ResultCode(115);
            CoinAlreadyExists = new ResultCode(201);
            WrongCrr = new ResultCode(202);
            InvalidCoinSymbol = new ResultCode(203);
            InvalidCoinName = new ResultCode(204);
            WrongCoinSupply = new ResultCode(205);
            CrossConvert = new ResultCode(301);
            MaximumValueToSellReached = new ResultCode(302);
            MinimumValueToBuylReached = new ResultCode(303);
            CandidateExists = new ResultCode(401);
            WrongCommission = new ResultCode(402);
            CandidateNotFound = new ResultCode(403);
            StakeNotFound = new ResultCode(404);
            InsufficientStake = new ResultCode(405);
            IsNotOwnerOfCandidate = new ResultCode(406);
            IncorrectPubKey = new ResultCode(407);
            StakeShouldBePositive = new ResultCode(408);
            TooLowStake = new ResultCode(409);
            CheckInvalidLock = new ResultCode(501);
            CheckExpired = new ResultCode(502);
            CheckUsed = new ResultCode(503);
            TooHighGasPrice = new ResultCode(504);
            WrongGasCoin = new ResultCode(505);
            IncorrectWeights = new ResultCode(601);
            MultisigExists = new ResultCode(602);
            MultisigNotExists = new ResultCode(603);
            IncorrectMultiSignature = new ResultCode(604);
            ResultCode resultCode2 = resultCode;
            TooLargeOwnersList = new ResultCode(605);
            $VALUES = new ResultCode[]{UnknownError, Success, WrongNonce, CoinNotExists, CoinReserveNotSufficient, TxTooLarge, DecodeError, InsufficientFunds, TxPayloadTooLarge, TxServiceDataTooLarge, InvalidMultisendData, CoinSupplyOverflow, TxFromSenderAlreadyInMempool, TooLowGasPrice, WrongChainId, CoinAlreadyExists, WrongCrr, InvalidCoinSymbol, InvalidCoinName, WrongCoinSupply, CrossConvert, MaximumValueToSellReached, MinimumValueToBuylReached, CandidateExists, WrongCommission, CandidateNotFound, StakeNotFound, InsufficientStake, IsNotOwnerOfCandidate, IncorrectPubKey, StakeShouldBePositive, TooLowStake, CheckInvalidLock, CheckExpired, CheckUsed, TooHighGasPrice, WrongGasCoin, IncorrectWeights, MultisigExists, MultisigNotExists, IncorrectMultiSignature, resultCode2};
        }

        public int getValue() {
            return this.resVal;
        }
    }
}

