/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.utils;

import java.math.BigInteger;
import network.minter.blockchain.models.operational.CheckTransaction;
import network.minter.blockchain.models.operational.ExternalTransaction;
import network.minter.blockchain.models.operational.OperationInvalidDataException;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.utils.Base64UrlSafe;
import network.minter.core.crypto.PrivateKey;

public class DeepLinkBuilder {
    public static final String BIP_WALLET_MAINNET = "https://bip.to";
    public static final String BIP_WALLET_TESTNET = "https://testnet.bip.to";
    public static String BIP_WALLET_URL = "https://bip.to";
    private ExternalTransaction mExternalTransaction;
    private String mBaseUrl;
    private String mCheckPass;

    public DeepLinkBuilder(Transaction transaction) {
        ExternalTransaction externalTransaction;
        DeepLinkBuilder deepLinkBuilder = externalTransaction2;
        ExternalTransaction externalTransaction2 = externalTransaction;
        externalTransaction = new ExternalTransaction(transaction);
        deepLinkBuilder(externalTransaction2);
    }

    public DeepLinkBuilder(CheckTransaction checkTransaction, PrivateKey privateKey, String string) {
        TxRedeemCheck txRedeemCheck;
        ((DeepLinkBuilder)((Object)txRedeemCheck2)).mBaseUrl = BIP_WALLET_URL;
        ((DeepLinkBuilder)((Object)txRedeemCheck2)).mCheckPass = null;
        TxRedeemCheck txRedeemCheck2 = txRedeemCheck;
        txRedeemCheck2();
        txRedeemCheck2.setRawCheck(checkTransaction.sign(privateKey).getTxSign());
        txRedeemCheck.setProof(CheckTransaction.makeProof(privateKey.getPublicKey().toMinter(), string).toHexString());
        v1.mExternalTransaction = new ExternalTransaction.Builder().setData(txRedeemCheck2).setGasCoin(checkTransaction.getGasCoin()).setGasPrice(BigInteger.ONE).setNonce(BigInteger.ZERO).build();
    }

    public DeepLinkBuilder(CheckTransaction checkTransaction, PrivateKey privateKey) {
        TxRedeemCheck txRedeemCheck;
        ((DeepLinkBuilder)((Object)txRedeemCheck2)).mBaseUrl = BIP_WALLET_URL;
        ((DeepLinkBuilder)((Object)txRedeemCheck2)).mCheckPass = null;
        TxRedeemCheck txRedeemCheck2 = txRedeemCheck;
        txRedeemCheck2();
        txRedeemCheck.setRawCheck(checkTransaction.sign(privateKey).getTxSign());
        v1.mExternalTransaction = new ExternalTransaction.Builder().setData(txRedeemCheck2).setGasCoin(checkTransaction.getGasCoin()).setGasPrice(BigInteger.ONE).setNonce(BigInteger.ZERO).build();
    }

    public DeepLinkBuilder(ExternalTransaction.Builder builder) {
        this.mBaseUrl = BIP_WALLET_URL;
        this.mCheckPass = null;
        this.mExternalTransaction = builder.build();
    }

    public DeepLinkBuilder(ExternalTransaction externalTransaction) {
        this.mBaseUrl = BIP_WALLET_URL;
        this.mCheckPass = null;
        this.mExternalTransaction = externalTransaction;
    }

    public DeepLinkBuilder(String string, Transaction transaction) {
        ExternalTransaction externalTransaction;
        DeepLinkBuilder deepLinkBuilder = externalTransaction2;
        ExternalTransaction externalTransaction2 = externalTransaction;
        externalTransaction = new ExternalTransaction(transaction);
        deepLinkBuilder(string, externalTransaction2);
    }

    public DeepLinkBuilder(String string, ExternalTransaction.Builder builder) {
        this(string, builder.build());
    }

    public DeepLinkBuilder(String string, ExternalTransaction externalTransaction) {
        this.mBaseUrl = BIP_WALLET_URL;
        this.mCheckPass = null;
        this.mBaseUrl = string;
        this.mExternalTransaction = externalTransaction;
    }

    public static Transaction decodeData(byte[] byArray) {
        return Transaction.fromEncoded(Base64UrlSafe.decode(byArray).toHexString());
    }

    public String build() {
        DeepLinkBuilder deepLinkBuilder = this;
        String string = this.mBaseUrl + "/tx/" + Base64UrlSafe.encode(deepLinkBuilder.mExternalTransaction.encode().getBytes()).stringValue();
        if (deepLinkBuilder.mCheckPass != null) {
            string = string + "?p=" + Base64UrlSafe.encodeString(this.mCheckPass);
        }
        return string;
    }

    public DeepLinkBuilder setCheckPassword(String string) {
        this.mCheckPass = string;
        return this;
    }

    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    public DeepLinkBuilder setBaseUrl(String string) {
        this.mBaseUrl = string;
        return this;
    }

    public Transaction getTransaction() throws OperationInvalidDataException {
        return this.mExternalTransaction.toTransaction();
    }
}

