/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.core.crypto.BytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class SignatureSingleData
extends SignatureData {
    public static final Parcelable.Creator<SignatureSingleData> CREATOR = new Parcelable.Creator<SignatureSingleData>(){

        public SignatureSingleData createFromParcel(Parcel parcel) {
            return new SignatureSingleData(parcel);
        }

        public SignatureSingleData[] newArray(int n) {
            return new SignatureSingleData[n];
        }
    };
    private BytesData mV;
    private BytesData mR;
    private BytesData mS;

    public SignatureSingleData() {
    }

    public SignatureSingleData(BytesData bytesData) {
        Preconditions.checkArgument((bytesData.size() == 65 ? 1 : 0) != 0, (Object)"Signature length must be 65 bytes");
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mR = new BytesData(bytesData.takeRange(0, 32));
        signatureSingleData.mS = new BytesData(bytesData.takeRange(32, 64));
        signatureSingleData.mV = new BytesData(bytesData.takeRange(64, 65));
    }

    public SignatureSingleData(NativeSecp256k1.RecoverableSignature recoverableSignature) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.setSign(recoverableSignature);
    }

    public SignatureSingleData(char[] cArray, char[] cArray2, char[] cArray3) {
        BytesData bytesData;
        BytesData bytesData2;
        BytesData bytesData3;
        Preconditions.checkArgument((cArray.length == 32 ? 1 : 0) != 0, (Object)"R length must be 32");
        Preconditions.checkArgument((cArray2.length == 32 ? 1 : 0) != 0, (Object)"S length must be 32");
        Preconditions.checkArgument((cArray3.length == 1 ? 1 : 0) != 0, (Object)"V length must be 1");
        SignatureSingleData signatureSingleData = signatureSingleData2;
        SignatureSingleData signatureSingleData2 = bytesData3;
        bytesData3 = new BytesData(cArray);
        signatureSingleData.mR = signatureSingleData2;
        signatureSingleData2 = bytesData2;
        bytesData2 = new BytesData(cArray2);
        signatureSingleData.mS = signatureSingleData2;
        signatureSingleData2 = bytesData;
        bytesData = new BytesData(cArray3);
        signatureSingleData.mV = signatureSingleData2;
    }

    public SignatureSingleData(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        BytesData bytesData;
        BytesData bytesData2;
        BytesData bytesData3;
        Preconditions.checkArgument((byArray.length == 32 ? 1 : 0) != 0, (Object)"R length must be 32");
        Preconditions.checkArgument((byArray2.length == 32 ? 1 : 0) != 0, (Object)"S length must be 32");
        Preconditions.checkArgument((byArray3.length == 1 ? 1 : 0) != 0, (Object)"V length must be 1");
        SignatureSingleData signatureSingleData = signatureSingleData2;
        SignatureSingleData signatureSingleData2 = bytesData3;
        bytesData3 = new BytesData(byArray);
        signatureSingleData.mR = signatureSingleData2;
        signatureSingleData2 = bytesData2;
        bytesData2 = new BytesData(byArray2);
        signatureSingleData.mS = signatureSingleData2;
        signatureSingleData2 = bytesData;
        bytesData = new BytesData(byArray3);
        signatureSingleData.mV = signatureSingleData2;
    }

    protected SignatureSingleData(Parcel parcel) {
        this.mV = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mR = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
        this.mS = (BytesData)parcel.readValue(BytesData.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mV);
        parcel.writeValue((Object)this.mR);
        parcel.writeValue((Object)this.mS);
    }

    public BytesData getR() {
        return this.mR;
    }

    public BytesData getS() {
        return this.mS;
    }

    public BytesData getV() {
        return this.mV;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mR;
        objectArray2[1] = this.mS;
        objectArray[2] = this.mV;
        return String.format("%s%s%s", objectArray2);
    }

    protected void setSign(NativeSecp256k1.RecoverableSignature recoverableSignature) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new BytesData(recoverableSignature.v, true);
        signatureSingleData.mR = new BytesData(recoverableSignature.r, true);
        signatureSingleData.mS = new BytesData(recoverableSignature.s, true);
    }

    protected void decodeRaw(byte[][] byArray) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new BytesData(byArray[0]);
        signatureSingleData.mR = new BytesData(byArray[1]);
        signatureSingleData.mS = new BytesData(byArray[2]);
    }

    protected void decodeRaw(char[][] cArray) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new BytesData(cArray[0]);
        signatureSingleData.mR = new BytesData(cArray[1]);
        signatureSingleData.mS = new BytesData(cArray[2]);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignatureSingleData)) {
            return false;
        }
        return this.mV.equals((Object)((SignatureSingleData)(object = (SignatureSingleData)object)).getV()) && this.mR.equals((Object)((SignatureSingleData)object).getR()) && this.mS.equals((Object)((SignatureSingleData)object).getS());
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        SignatureSingleData signatureSingleData = object;
        Object object = signatureSingleData.mV.getData();
        char[] cArray = BytesHelper.dropLeadingZeroes((char[])signatureSingleData.mR.getData());
        char[] cArray2 = BytesHelper.dropLeadingZeroes((char[])signatureSingleData.mS.getData());
        return RLPBoxed.encode((Object)new Object[]{object, cArray, cArray2});
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        SignatureSingleData signatureSingleData = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        signatureSingleData.mV = new BytesData(this.fromRawRlp(0, objectArray));
        signatureSingleData.mR = new BytesData(this.fromRawRlp(1, objectArray));
        signatureSingleData.mS = new BytesData(this.fromRawRlp(2, objectArray));
    }
}

