/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.util.RLPBoxed;

public class TxEditCandidate
extends Operation {
    public static final Parcelable.Creator<TxEditCandidate> CREATOR = new Parcelable.Creator<TxEditCandidate>(){

        public TxEditCandidate createFromParcel(Parcel parcel) {
            return new TxEditCandidate(parcel);
        }

        public TxEditCandidate[] newArray(int n) {
            return new TxEditCandidate[n];
        }
    };
    private MinterPublicKey mPubKey;
    private MinterAddress mRewardAddress;
    private MinterAddress mOwnerAddress;

    public TxEditCandidate() {
    }

    public TxEditCandidate(@Nonnull Transaction transaction) {
        super(transaction);
    }

    protected TxEditCandidate(Parcel parcel) {
        super(parcel);
        this.mPubKey = (MinterPublicKey)parcel.readValue(MinterPublicKey.class.getClassLoader());
        this.mRewardAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
        this.mOwnerAddress = (MinterAddress)parcel.readValue(MinterAddress.class.getClassLoader());
    }

    public TxEditCandidate setPublicKey(MinterPublicKey minterPublicKey) {
        this.mPubKey = minterPublicKey;
        return this;
    }

    public MinterPublicKey getPubKey() {
        return this.mPubKey;
    }

    public MinterAddress getRewardAddress() {
        return this.mRewardAddress;
    }

    public TxEditCandidate setRewardAddress(MinterAddress minterAddress) {
        this.mRewardAddress = minterAddress;
        return this;
    }

    public MinterAddress getOwnerAddress() {
        return this.mOwnerAddress;
    }

    public TxEditCandidate setOwnerAddress(MinterAddress minterAddress) {
        this.mOwnerAddress = minterAddress;
        return this;
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxEditCandidate txEditCandidate = this;
        super.writeToParcel(parcel, n);
        parcel.writeValue((Object)txEditCandidate.mPubKey);
        parcel.writeValue((Object)this.mRewardAddress);
        parcel.writeValue((Object)this.mOwnerAddress);
    }

    @Override
    public OperationType getType() {
        return OperationType.EditCandidate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mPubKey";
        boolean bl = ((TxEditCandidate)((Object)fieldsValidationResult2)).mPubKey != null;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Node public key must be set");
        string = "mRewardAddress";
        bl = ((TxEditCandidate)((Object)fieldsValidationResult2)).mRewardAddress != null;
        TxEditCandidate txEditCandidate = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl, "Reward address must be set");
        object = "mOwnerAddress";
        boolean bl2 = txEditCandidate.mOwnerAddress != null;
        return fieldsValidationResult2.addResult((String)object, bl2, "Owner address must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        TxEditCandidate txEditCandidate = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        txEditCandidate.mPubKey = new MinterPublicKey(this.fromRawRlp(0, objectArray));
        txEditCandidate.mRewardAddress = new MinterAddress(this.fromRawRlp(1, objectArray));
        txEditCandidate.mOwnerAddress = new MinterAddress(this.fromRawRlp(2, objectArray));
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mPubKey;
        objectArray2[1] = this.mRewardAddress;
        objectArray[2] = this.mOwnerAddress;
        return RLPBoxed.encode((Object)objectArray);
    }
}

