/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.BlockChainCoinEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.Coin;
import network.minter.blockchain.models.ExchangeBuyValue;
import network.minter.blockchain.models.ExchangeSellValue;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainCoinRepository
extends DataRepository<BlockChainCoinEndpoint> {
    public BlockChainCoinRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<BCResult<Coin>> getCoinInfo(@Nonnull String string) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinInformation((String)Preconditions.checkNotNull((Object)string, (String)"Symbol required"));
    }

    public Call<BCResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String string, BigDecimal bigDecimal, @Nonnull String string2) {
        return this.getCoinExchangeCurrencyToSell(string, Transaction.normalizeValue(bigDecimal), string2);
    }

    public Call<BCResult<ExchangeSellValue>> getCoinExchangeCurrencyToSell(@Nonnull String string, BigInteger bigInteger, @Nonnull String string2) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinExchangeCurrencyToSell(((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase(), bigInteger.toString(), ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase());
    }

    public Call<BCResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigDecimal bigDecimal, @Nonnull String string2) {
        return this.getCoinExchangeCurrencyToBuy(string, Transaction.normalizeValue(bigDecimal), string2);
    }

    public Call<BCResult<ExchangeBuyValue>> getCoinExchangeCurrencyToBuy(@Nonnull String string, BigInteger bigInteger, @Nonnull String string2) {
        return ((BlockChainCoinEndpoint)this.getInstantService()).getCoinExchangeCurrencyToBuy(((String)Preconditions.checkNotNull((Object)string, (String)"Source coin required")).toUpperCase(), bigInteger.toString(), ((String)Preconditions.checkNotNull((Object)string2, (String)"Target coin required")).toUpperCase());
    }

    @Nonnull
    protected Class<BlockChainCoinEndpoint> getServiceClass() {
        return BlockChainCoinEndpoint.class;
    }
}

