/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.core.crypto.UnsignedBytesData;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.RLPBoxed;

public final class SignatureSingleData
extends SignatureData {
    public static final Parcelable.Creator<SignatureSingleData> CREATOR = new Parcelable.Creator<SignatureSingleData>(){

        public Object[] newArray(int n) {
            return new SignatureSingleData[n];
        }

        public Object createFromParcel(Parcel parcel) {
            return new SignatureSingleData(parcel);
        }
    };
    private UnsignedBytesData mV;
    private UnsignedBytesData mR;
    private UnsignedBytesData mS;

    public SignatureSingleData() {
    }

    protected SignatureSingleData(Parcel parcel) {
        this.mV = (UnsignedBytesData)parcel.readValue(UnsignedBytesData.class.getClassLoader());
        this.mR = (UnsignedBytesData)parcel.readValue(UnsignedBytesData.class.getClassLoader());
        this.mS = (UnsignedBytesData)parcel.readValue(UnsignedBytesData.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.mV);
        parcel.writeValue((Object)this.mR);
        parcel.writeValue((Object)this.mS);
    }

    public UnsignedBytesData getR() {
        return this.mR;
    }

    public UnsignedBytesData getS() {
        return this.mS;
    }

    public UnsignedBytesData getV() {
        return this.mV;
    }

    protected void setSign(NativeSecp256k1.RecoverableSignature recoverableSignature) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new UnsignedBytesData(recoverableSignature.v, true);
        signatureSingleData.mR = new UnsignedBytesData(recoverableSignature.r, true);
        signatureSingleData.mS = new UnsignedBytesData(recoverableSignature.s, true);
    }

    protected void decodeRaw(byte[][] byArray) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new UnsignedBytesData(byArray[0]);
        signatureSingleData.mR = new UnsignedBytesData(byArray[1]);
        signatureSingleData.mS = new UnsignedBytesData(byArray[2]);
    }

    protected void decodeRaw(char[][] cArray) {
        SignatureSingleData signatureSingleData = this;
        signatureSingleData.mV = new UnsignedBytesData(cArray[0]);
        signatureSingleData.mR = new UnsignedBytesData(cArray[1]);
        signatureSingleData.mS = new UnsignedBytesData(cArray[2]);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] objectArray) {
        SignatureSingleData signatureSingleData = this;
        objectArray = (Object[])RLPBoxed.decode((char[])objectArray, (int)0).getDecoded();
        signatureSingleData.mV = new UnsignedBytesData(this.fromRawRlp(0, objectArray));
        signatureSingleData.mR = new UnsignedBytesData(this.fromRawRlp(1, objectArray));
        signatureSingleData.mS = new UnsignedBytesData(this.fromRawRlp(2, objectArray));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignatureSingleData)) {
            return false;
        }
        return this.mV.equals((Object)((SignatureSingleData)(object = (SignatureSingleData)object)).getV()) && this.mR.equals((Object)((SignatureSingleData)object).getR()) && this.mS.equals((Object)((SignatureSingleData)object).getS());
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        SignatureSingleData signatureSingleData = object;
        Object object = signatureSingleData.mV.getData();
        char[] cArray = BytesHelper.dropLeadingZeroes((char[])signatureSingleData.mR.getData());
        char[] cArray2 = BytesHelper.dropLeadingZeroes((char[])signatureSingleData.mS.getData());
        return RLPBoxed.encode((Object)new Object[]{object, cArray, cArray2});
    }
}

