/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class FieldsValidationResult {
    private final List<Pair<String, String>> mFieldMessageMap = new ArrayList<Pair<String, String>>();
    private String mTitle;

    public FieldsValidationResult() {
    }

    public FieldsValidationResult(String title) {
        this.mTitle = title;
    }

    public FieldsValidationResult addResult(String field, String errorMessage) {
        this.mFieldMessageMap.add((Pair<String, String>)Pair.create((Object)field, (Object)errorMessage));
        return this;
    }

    public FieldsValidationResult addResult(String field, boolean valid, String message) {
        if (!valid) {
            this.mFieldMessageMap.add((Pair<String, String>)Pair.create((Object)field, (Object)message));
        }
        return this;
    }

    public FieldsValidationResult addResult(FieldsValidationResult result) {
        if (result == null || result.isValid()) {
            return this;
        }
        this.mFieldMessageMap.addAll(result.getFieldMessageMap());
        return this;
    }

    public List<Pair<String, String>> getFieldMessageMap() {
        return this.mFieldMessageMap;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getInvalidFieldsMessages() {
        if (this.isValid()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Pair<String, String> kv : this.mFieldMessageMap) {
            sb.append((String)kv.first).append(": ").append((String)kv.second).append("\n");
        }
        return sb.toString();
    }

    public final boolean isValid() {
        return this.mFieldMessageMap.isEmpty();
    }
}

