/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;

public class BCResult<Result> {
    public ResultCode code = ResultCode.Success;
    public int statusCode = 200;
    @SerializedName(value="result")
    public Result result;
    @SerializedName(value="log")
    public String message;

    public static <T> BCResult<T> copyError(BCResult<?> another) {
        BCResult out = new BCResult();
        out.statusCode = another.statusCode;
        out.code = another.code;
        out.message = another.message;
        return out;
    }

    public boolean isSuccess() {
        return this.statusCode == 200 && this.code == ResultCode.Success;
    }

    public static enum ResultCode {
        Unknown(-1),
        EmptyResponse(1000),
        Success(0),
        DecodeError(1),
        InsufficientFundsB(107),
        InsufficientFunds(2),
        UnknownTransactionType(3),
        WrongNonce(4),
        CoinNotExists(5),
        CoinAlreadyExists(6),
        CoinDoesNotExists(301),
        WrongCrr(7),
        CrossConvert(8),
        CandidateExists(9),
        WrongCommission(10),
        CandidateNotFound(11);

        final int resVal;

        private ResultCode(int v) {
            this.resVal = v;
        }

        public int getValue() {
            return this.resVal;
        }
    }
}

