/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.android.cat;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.vrallev.android.cat.CatGlobal;
import net.vrallev.android.cat.print.AndroidLog;
import net.vrallev.android.cat.print.CatPrinter;

public abstract class CatLog {
    private final List<CatPrinter> mPrinters = new ArrayList<CatPrinter>();

    protected CatLog() {
        this.mPrinters.add(new AndroidLog());
    }

    protected abstract String getTag();

    public synchronized void addPrinter(CatPrinter printer) {
        this.mPrinters.add(printer);
    }

    protected synchronized List<? extends CatPrinter> getPrinters() {
        return this.mPrinters;
    }

    public void d(String message) {
        this.println(3, message, null);
    }

    public void d(String message, Object ... args) {
        this.println(3, CatLog.format(message, args), null);
    }

    public void d(Throwable t, String message, Object ... args) {
        this.println(3, CatLog.format(message, args), t);
    }

    public void i(String message) {
        this.println(4, message, null);
    }

    public void i(String message, Object ... args) {
        this.println(4, CatLog.format(message, args), null);
    }

    public void i(Throwable t, String message, Object ... args) {
        this.println(4, CatLog.format(message, args), t);
    }

    public void w(String message) {
        this.println(5, message, null);
    }

    public void w(String message, Object ... args) {
        this.println(5, CatLog.format(message, args), null);
    }

    public void w(Throwable t, String message, Object ... args) {
        this.println(5, CatLog.format(message, args), t);
    }

    public void w(Throwable t) {
        if (t == null) {
            t = new Exception("null exception logged");
        }
        this.println(5, t.getMessage(), t);
    }

    public void e(Throwable t) {
        if (t == null) {
            t = new Exception("null exception logged");
        }
        this.println(6, t.getMessage(), t);
    }

    public void e(String message) {
        this.println(6, message, null);
    }

    public void e(String message, Object ... args) {
        this.println(6, CatLog.format(message, args), null);
    }

    public void e(Throwable t, String message, Object ... args) {
        this.println(6, CatLog.format(message, args), t);
    }

    public void v(String message) {
        this.println(2, message, null);
    }

    public void v(String message, Object ... args) {
        this.println(2, CatLog.format(message, args), null);
    }

    public void v(Throwable t, String message, Object ... args) {
        this.println(2, CatLog.format(message, args), t);
    }

    protected void println(int priority, String message, Throwable t) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            message = "empty message";
        }
        CatGlobal.print(priority, this.getTag(), message, t, this.getPrinters());
    }

    private static String format(String message, Object[] args) {
        if (message == null) {
            return "null";
        }
        return String.format(Locale.US, message, args);
    }
}

