/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultElmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DirectoryCacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.ElmInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.ElmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallElmExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.io.File;

public class ElmPluginFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final File workingDirectory;
    private final File installDirectory;
    private final CacheResolver cacheResolver;

    public ElmPluginFactory(File workingDirectory, File installDirectory) {
        this(workingDirectory, installDirectory, ElmPluginFactory.getDefaultCacheResolver(installDirectory));
    }

    public ElmPluginFactory(File workingDirectory, File installDirectory, CacheResolver cacheResolver) {
        this.workingDirectory = workingDirectory;
        this.installDirectory = installDirectory;
        this.cacheResolver = cacheResolver;
    }

    public ElmInstaller getElmInstaller(ProxyConfig proxy) {
        return new ElmInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)new DefaultFileDownloader(proxy));
    }

    public ElmRunner getElmRunner() {
        return new DefaultElmRunner(new InstallElmExecutorConfig(this.getInstallConfig()));
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDirectory, this.workingDirectory, this.cacheResolver, defaultPlatform);
    }

    private static final CacheResolver getDefaultCacheResolver(File root) {
        return new DirectoryCacheResolver(new File(root, DEFAULT_CACHE_PATH));
    }
}

