/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener.logging;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.listener.logging.AbstractQueryLogEntryCreator;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

public class DefaultJsonQueryLogEntryCreator
extends AbstractQueryLogEntryCreator {
    @Override
    public String getLogEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName, boolean writeConnectionId, boolean writeIsolation) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (writeDataSourceName) {
            this.writeDataSourceNameEntry(sb, execInfo, queryInfoList);
        }
        if (writeConnectionId) {
            this.writeConnectionIdEntry(sb, execInfo, queryInfoList);
        }
        if (writeIsolation) {
            this.writeIsolationEntry(sb, execInfo, queryInfoList);
        }
        this.writeTimeEntry(sb, execInfo, queryInfoList);
        this.writeResultEntry(sb, execInfo, queryInfoList);
        this.writeTypeEntry(sb, execInfo, queryInfoList);
        this.writeBatchEntry(sb, execInfo, queryInfoList);
        this.writeQuerySizeEntry(sb, execInfo, queryInfoList);
        this.writeBatchSizeEntry(sb, execInfo, queryInfoList);
        this.writeQueriesEntry(sb, execInfo, queryInfoList);
        this.writeParamsEntry(sb, execInfo, queryInfoList);
        return sb.toString();
    }

    protected void writeDataSourceNameEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String name = execInfo.getDataSourceName();
        sb.append("\"name\":\"");
        sb.append(name == null ? "" : this.escapeSpecialCharacter(name));
        sb.append("\", ");
    }

    protected void writeConnectionIdEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"connection\":");
        sb.append(execInfo.getConnectionId());
        sb.append(", ");
    }

    protected void writeIsolationEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"isolation\":\"");
        sb.append(this.getTransactionIsolation(execInfo.getIsolationLevel()));
        sb.append("\", ");
    }

    protected void writeTimeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"time\":");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
    }

    protected void writeResultEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"success\":");
        sb.append(execInfo.isSuccess() ? "true" : "false");
        sb.append(", ");
    }

    protected void writeTypeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"type\":\"");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append("\", ");
    }

    protected void writeBatchEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"batch\":");
        sb.append(execInfo.isBatch() ? "true" : "false");
        sb.append(", ");
    }

    protected void writeQuerySizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"querySize\":");
        sb.append(queryInfoList.size());
        sb.append(", ");
    }

    protected void writeBatchSizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"batchSize\":");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
    }

    protected void writeQueriesEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"query\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(this.escapeSpecialCharacter(queryInfo.getQuery()));
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
    }

    protected void writeParamsEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        boolean isPrepared = execInfo.getStatementType() == StatementType.PREPARED;
        sb.append("\"params\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (List<ParameterSetOperation> parameters : queryInfo.getParametersList()) {
                SortedMap<String, String> paramMap = this.getParametersToDisplay(parameters);
                if (isPrepared) {
                    this.writeParamsForSinglePreparedEntry(sb, paramMap, execInfo, queryInfoList);
                    continue;
                }
                this.writeParamsForSingleCallableEntry(sb, paramMap, execInfo, queryInfoList);
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
        sb.append("}");
    }

    protected void writeParamsForSinglePreparedEntry(StringBuilder sb, SortedMap<String, String> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("[");
        for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
            String value = paramEntry.getValue();
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(this.escapeSpecialCharacter(value.toString()));
                sb.append("\"");
            }
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("],");
    }

    protected void writeParamsForSingleCallableEntry(StringBuilder sb, Map<String, String> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("{");
        for (Map.Entry<String, String> paramEntry : paramMap.entrySet()) {
            String key = paramEntry.getKey();
            String value = paramEntry.getValue();
            sb.append("\"");
            sb.append(this.escapeSpecialCharacter(key));
            sb.append("\":");
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(this.escapeSpecialCharacter(value.toString()));
                sb.append("\"");
            }
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("},");
    }

    protected String escapeSpecialCharacter(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String value = (String)JSON_SPECIAL_CHARS.get(Character.valueOf(c));
            sb.append(value != null ? value : Character.valueOf(c));
        }
        return sb.toString();
    }
}

