/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class ZonalTransition
implements Comparable<ZonalTransition>,
Serializable {
    private static final long serialVersionUID = 4594838367057225304L;
    private final long posix;
    private final int previous;
    private final int total;
    private final int dst;

    public ZonalTransition(long l, int n, int n2, int n3) {
        this.posix = l;
        this.previous = n;
        this.total = n2;
        this.dst = n3;
        ZonalTransition.checkRange(n);
        ZonalTransition.checkRange(n2);
        ZonalTransition.checkDST(n3);
    }

    public long getPosixTime() {
        return this.posix;
    }

    public int getPreviousOffset() {
        return this.previous;
    }

    public int getTotalOffset() {
        return this.total;
    }

    public int getStandardOffset() {
        return this.total - this.getDaylightSavingOffset();
    }

    public int getDaylightSavingOffset() {
        return this.dst == Integer.MAX_VALUE ? 0 : this.dst;
    }

    public boolean isDaylightSaving() {
        return this.dst > 0;
    }

    public int getSize() {
        return this.total - this.previous;
    }

    public boolean isGap() {
        return this.total > this.previous;
    }

    public boolean isOverlap() {
        return this.total < this.previous;
    }

    @Override
    public int compareTo(ZonalTransition zonalTransition) {
        long l = this.posix - zonalTransition.posix;
        if (l == 0L && (l = (long)(this.previous - zonalTransition.previous)) == 0L && (l = (long)(this.total - zonalTransition.total)) == 0L && (l = (long)(this.dst - zonalTransition.dst)) == 0L) {
            return 0;
        }
        return l < 0L ? -1 : 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalTransition) {
            ZonalTransition zonalTransition = (ZonalTransition)object;
            if (this.posix == zonalTransition.posix && this.previous == zonalTransition.previous && this.total == zonalTransition.total && this.dst == zonalTransition.dst) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.posix ^ this.posix >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("[POSIX=");
        stringBuilder.append(this.posix);
        stringBuilder.append(", previous-offset=");
        stringBuilder.append(this.previous);
        stringBuilder.append(", total-offset=");
        stringBuilder.append(this.total);
        stringBuilder.append(", dst-offset=");
        stringBuilder.append(this.dst);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static void checkRange(int n) {
        if (n < -64800 || n > 64800) {
            throw new IllegalArgumentException("Offset out of range: " + n);
        }
    }

    private static void checkDST(int n) {
        if (n != Integer.MAX_VALUE) {
            ZonalTransition.checkRange(n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            ZonalTransition.checkRange(this.previous);
            ZonalTransition.checkRange(this.total);
            ZonalTransition.checkDST(this.dst);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
    }
}

