/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.base.ResourceLoader;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralProvider;
import net.time4j.format.internal.FormatUtils;

public abstract class PluralRules {
    private static final PluralRules FALLBACK_CARDINAL_ENGLISH = new FallbackRules(NumberType.CARDINALS, true);
    private static final PluralRules FALLBACK_CARDINAL_OTHER = new FallbackRules(NumberType.CARDINALS, false);
    private static final PluralRules FALLBACK_ORDINAL_ENGLISH = new FallbackRules(NumberType.ORDINALS, true);
    private static final PluralRules FALLBACK_ORDINAL_OTHER = new FallbackRules(NumberType.ORDINALS, false);
    private static final Map<String, PluralRules> CARDINAL_MAP = new ConcurrentHashMap<String, PluralRules>();
    private static final Map<String, PluralRules> ORDINAL_MAP = new ConcurrentHashMap<String, PluralRules>();

    public static PluralRules of(Locale locale, NumberType numberType) {
        Map<String, PluralRules> map = PluralRules.getRuleMap(numberType);
        PluralRules pluralRules = null;
        if (!map.isEmpty()) {
            String string = FormatUtils.getRegion(locale);
            if (!string.isEmpty()) {
                pluralRules = map.get(PluralRules.toKey(locale.getLanguage(), string));
            }
            if (pluralRules == null) {
                pluralRules = map.get(locale.getLanguage());
            }
        }
        if (pluralRules == null) {
            pluralRules = Holder.PROVIDER.load(locale, numberType);
        }
        return pluralRules;
    }

    public static void register(Locale locale, PluralRules pluralRules) {
        Map<String, PluralRules> map = PluralRules.getRuleMap(pluralRules.getNumberType());
        String string = locale.getLanguage();
        String string2 = FormatUtils.getRegion(locale);
        if (!string2.isEmpty()) {
            string = PluralRules.toKey(string, string2);
        }
        map.put(string, pluralRules);
    }

    public abstract PluralCategory getCategory(long var1);

    public abstract NumberType getNumberType();

    private static Map<String, PluralRules> getRuleMap(NumberType numberType) {
        switch (numberType) {
            case CARDINALS: {
                return CARDINAL_MAP;
            }
            case ORDINALS: {
                return ORDINAL_MAP;
            }
        }
        throw new UnsupportedOperationException(numberType.name());
    }

    private static String toKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('_');
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static class Holder {
        private static final PluralProvider PROVIDER;

        private Holder() {
        }

        static {
            PluralProvider pluralProvider = null;
            Iterator<PluralProvider> iterator = ResourceLoader.getInstance().services(PluralProvider.class).iterator();
            if (iterator.hasNext()) {
                PluralProvider pluralProvider2;
                pluralProvider = pluralProvider2 = iterator.next();
            }
            if (pluralProvider == null) {
                pluralProvider = new FallbackProvider();
            }
            PROVIDER = pluralProvider;
        }
    }

    private static class FallbackProvider
    implements PluralProvider {
        private FallbackProvider() {
        }

        @Override
        public PluralRules load(Locale locale, NumberType numberType) {
            boolean bl = locale.getLanguage().equals("en");
            switch (numberType) {
                case CARDINALS: {
                    return bl ? FALLBACK_CARDINAL_ENGLISH : FALLBACK_CARDINAL_OTHER;
                }
                case ORDINALS: {
                    return bl ? FALLBACK_ORDINAL_ENGLISH : FALLBACK_ORDINAL_OTHER;
                }
            }
            throw new UnsupportedOperationException(numberType.name());
        }
    }

    private static class FallbackRules
    extends PluralRules {
        private final NumberType numType;
        private final boolean english;

        private FallbackRules(NumberType numberType, boolean bl) {
            this.numType = numberType;
            this.english = bl;
        }

        @Override
        public PluralCategory getCategory(long l) {
            switch (this.numType) {
                case CARDINALS: {
                    return l == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case ORDINALS: {
                    if (this.english) {
                        long l2 = l % 10L;
                        long l3 = l % 100L;
                        if (l2 == 1L && l3 != 11L) {
                            return PluralCategory.ONE;
                        }
                        if (l2 == 2L && l3 != 12L) {
                            return PluralCategory.TWO;
                        }
                        if (l2 == 3L && l3 != 13L) {
                            return PluralCategory.FEW;
                        }
                    }
                    return PluralCategory.OTHER;
                }
            }
            throw new UnsupportedOperationException(this.numType.name());
        }

        @Override
        public NumberType getNumberType() {
            return this.numType;
        }
    }
}

