/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.engine.BasicElement;
import net.time4j.format.CalendarText;

public abstract class DisplayElement<V extends Comparable<V>>
extends BasicElement<V> {
    private static final Map<String, String> OTHER_DISPLAY_KEYS;

    protected DisplayElement(String string) {
        super(string);
    }

    @Override
    public String getDisplayName(Locale locale) {
        String string;
        String string2;
        switch (this.getSymbol()) {
            case 'G': {
                string2 = "L_era";
                break;
            }
            case 'Y': 
            case 'u': 
            case 'y': {
                string2 = "L_year";
                break;
            }
            case 'Q': {
                string2 = "L_quarter";
                break;
            }
            case 'M': {
                string2 = "L_month";
                break;
            }
            case 'W': 
            case 'w': {
                string2 = "L_week";
                break;
            }
            case 'd': {
                string2 = "L_day";
                break;
            }
            case 'E': 
            case 'e': {
                string2 = "L_weekday";
                break;
            }
            case 'H': 
            case 'K': 
            case 'h': 
            case 'k': {
                string2 = "L_hour";
                break;
            }
            case 'm': {
                string2 = "L_minute";
                break;
            }
            case 's': {
                string2 = "L_second";
                break;
            }
            default: {
                string = this.name();
                string2 = OTHER_DISPLAY_KEYS.get(string);
                if (string2 != null) break;
                return string;
            }
        }
        string = CalendarText.getIsoInstance(locale).getTextForms().get(string2);
        return string == null ? this.name() : string;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("YEAR_OF_DISPLAY", "L_year");
        hashMap.put("MONTH_AS_NUMBER", "L_month");
        hashMap.put("HOUR_FROM_0_TO_24", "L_hour");
        hashMap.put("DAY_OF_MONTH", "L_day");
        OTHER_DISPLAY_KEYS = Collections.unmodifiableMap(hashMap);
    }
}

