/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.engine.TimeSpan;

final class JSR310DurationAdapter
implements TemporalAmount,
Serializable {
    private static final Map<IsoUnit, TemporalUnit> MAP;
    private final Duration<?> duration;

    JSR310DurationAdapter(Duration<?> duration) {
        this.duration = duration;
        for (TimeSpan.Item<?> item : duration.getTotalLength()) {
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (MAP.containsKey(isoUnit)) continue;
            throw new UnsupportedOperationException("Cannot be used in any TemporalAmount: " + isoUnit);
        }
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        for (Map.Entry<IsoUnit, TemporalUnit> entry : MAP.entrySet()) {
            if (!entry.getValue().equals(temporalUnit)) continue;
            long l = this.duration.getPartialAmount(entry.getKey());
            if (this.duration.isNegative()) {
                l = Math.negateExact(l);
            }
            return l;
        }
        if (temporalUnit.equals(ChronoUnit.HALF_DAYS)) {
            long l = Math.floorDiv(this.duration.getPartialAmount(ClockUnit.HOURS), 12L);
            if (this.duration.isNegative()) {
                l = Math.negateExact(l);
            }
            return l;
        }
        throw new UnsupportedTemporalTypeException(temporalUnit.toString());
    }

    @Override
    public List<TemporalUnit> getUnits() {
        ArrayList<TemporalUnit> arrayList = new ArrayList<TemporalUnit>();
        for (TimeSpan.Item<?> item : this.duration.getTotalLength()) {
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            arrayList.add(MAP.get(isoUnit));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return JSR310DurationAdapter.apply(temporal, this.duration);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return JSR310DurationAdapter.apply(temporal, this.duration.inverse());
    }

    private static Temporal apply(Temporal temporal, Duration<?> duration) {
        boolean bl;
        boolean bl2 = bl = temporal instanceof LocalDateTime || temporal instanceof LocalDate || temporal instanceof LocalTime;
        if (!bl) {
            throw new DateTimeException("Duration is only applicable on LocalDate, LocalTime or LocalDateTime.");
        }
        long l = duration.getPartialAmount(CalendarUnit.weekBasedYears());
        long l2 = Math.multiplyExact(duration.getPartialAmount(CalendarUnit.MILLENNIA), 12000L);
        l2 = Math.addExact(l2, Math.multiplyExact(duration.getPartialAmount(CalendarUnit.CENTURIES), 1200L));
        l2 = Math.addExact(l2, Math.multiplyExact(duration.getPartialAmount(CalendarUnit.DECADES), 120L));
        l2 = Math.addExact(l2, Math.multiplyExact(duration.getPartialAmount(CalendarUnit.YEARS), 12L));
        l2 = Math.addExact(l2, Math.multiplyExact(duration.getPartialAmount(CalendarUnit.QUARTERS), 3L));
        l2 = Math.addExact(l2, duration.getPartialAmount(CalendarUnit.MONTHS));
        long l3 = Math.multiplyExact(duration.getPartialAmount(CalendarUnit.WEEKS), 7L);
        l3 = Math.addExact(l3, duration.getPartialAmount(CalendarUnit.DAYS));
        long l4 = Math.multiplyExact(duration.getPartialAmount(ClockUnit.HOURS), 3600L);
        l4 = Math.addExact(l4, Math.multiplyExact(duration.getPartialAmount(ClockUnit.MINUTES), 60L));
        l4 = Math.addExact(l4, duration.getPartialAmount(ClockUnit.SECONDS));
        long l5 = duration.getPartialAmount(ClockUnit.NANOS);
        if (duration.isNegative()) {
            if (l5 > 0L) {
                temporal = temporal.minus(l5, ChronoUnit.NANOS);
            }
            if (l4 > 0L) {
                temporal = temporal.minus(l4, ChronoUnit.SECONDS);
            }
            if (l3 > 0L) {
                temporal = temporal.minus(l3, ChronoUnit.DAYS);
            }
            if (l2 > 0L) {
                temporal = temporal.minus(l2, ChronoUnit.MONTHS);
            }
            if (l > 0L) {
                temporal = temporal.minus(l, IsoFields.WEEK_BASED_YEARS);
            }
        } else {
            if (l > 0L) {
                temporal = temporal.plus(l, IsoFields.WEEK_BASED_YEARS);
            }
            if (l2 > 0L) {
                temporal = temporal.plus(l2, ChronoUnit.MONTHS);
            }
            if (l3 > 0L) {
                temporal = temporal.plus(l3, ChronoUnit.DAYS);
            }
            if (l4 > 0L) {
                temporal = temporal.plus(l4, ChronoUnit.SECONDS);
            }
            if (l5 > 0L) {
                temporal = temporal.plus(l5, ChronoUnit.NANOS);
            }
        }
        return temporal;
    }

    static {
        HashMap<IsoUnit, TemporalUnit> hashMap = new HashMap<IsoUnit, TemporalUnit>();
        hashMap.put(CalendarUnit.MILLENNIA, ChronoUnit.MILLENNIA);
        hashMap.put(CalendarUnit.CENTURIES, ChronoUnit.CENTURIES);
        hashMap.put(CalendarUnit.DECADES, ChronoUnit.DECADES);
        hashMap.put(CalendarUnit.YEARS, ChronoUnit.YEARS);
        hashMap.put(CalendarUnit.QUARTERS, IsoFields.QUARTER_YEARS);
        hashMap.put(CalendarUnit.MONTHS, ChronoUnit.MONTHS);
        hashMap.put(CalendarUnit.WEEKS, ChronoUnit.WEEKS);
        hashMap.put(CalendarUnit.DAYS, ChronoUnit.DAYS);
        hashMap.put(CalendarUnit.weekBasedYears(), IsoFields.WEEK_BASED_YEARS);
        hashMap.put(ClockUnit.HOURS, ChronoUnit.HOURS);
        hashMap.put(ClockUnit.MINUTES, ChronoUnit.MINUTES);
        hashMap.put(ClockUnit.SECONDS, ChronoUnit.SECONDS);
        hashMap.put(ClockUnit.MILLIS, ChronoUnit.MILLIS);
        hashMap.put(ClockUnit.MICROS, ChronoUnit.MICROS);
        hashMap.put(ClockUnit.NANOS, ChronoUnit.NANOS);
        MAP = Collections.unmodifiableMap(hashMap);
    }
}

