/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.Chronology;
import net.time4j.engine.StartOfDay;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.PredefinedKey;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

public final class Attributes
implements AttributeQuery {
    public static final AttributeKey<String> CALENDAR_TYPE = PredefinedKey.valueOf("CALENDAR_TYPE", String.class);
    public static final AttributeKey<Locale> LANGUAGE = PredefinedKey.valueOf("LANGUAGE", Locale.class);
    public static final AttributeKey<TZID> TIMEZONE_ID = PredefinedKey.valueOf("TIMEZONE_ID", TZID.class);
    public static final AttributeKey<TransitionStrategy> TRANSITION_STRATEGY = PredefinedKey.valueOf("TRANSITION_STRATEGY", TransitionStrategy.class);
    public static final AttributeKey<Leniency> LENIENCY = PredefinedKey.valueOf("LENIENCY", Leniency.class);
    public static final AttributeKey<TextWidth> TEXT_WIDTH = PredefinedKey.valueOf("TEXT_WIDTH", TextWidth.class);
    public static final AttributeKey<OutputContext> OUTPUT_CONTEXT = PredefinedKey.valueOf("OUTPUT_CONTEXT", OutputContext.class);
    public static final AttributeKey<Boolean> PARSE_CASE_INSENSITIVE = PredefinedKey.valueOf("PARSE_CASE_INSENSITIVE", Boolean.class);
    public static final AttributeKey<Boolean> PARSE_PARTIAL_COMPARE = PredefinedKey.valueOf("PARSE_PARTIAL_COMPARE", Boolean.class);
    public static final AttributeKey<NumberSystem> NUMBER_SYSTEM = PredefinedKey.valueOf("NUMBER_SYSTEM", NumberSystem.class);
    public static final AttributeKey<Character> ZERO_DIGIT = PredefinedKey.valueOf("ZERO_DIGIT", Character.class);
    public static final AttributeKey<Character> DECIMAL_SEPARATOR = PredefinedKey.valueOf("DECIMAL_SEPARATOR", Character.class);
    public static final AttributeKey<Character> PAD_CHAR = PredefinedKey.valueOf("PAD_CHAR", Character.class);
    public static final AttributeKey<Integer> PIVOT_YEAR = PredefinedKey.valueOf("PIVOT_YEAR", Integer.class);
    public static final AttributeKey<Boolean> TRAILING_CHARACTERS = PredefinedKey.valueOf("TRAILING_CHARACTERS", Boolean.class);
    public static final AttributeKey<Integer> PROTECTED_CHARACTERS = PredefinedKey.valueOf("PROTECTED_CHARACTERS", Integer.class);
    public static final AttributeKey<String> CALENDAR_VARIANT = PredefinedKey.valueOf("CALENDAR_VARIANT", String.class);
    public static final AttributeKey<StartOfDay> START_OF_DAY = PredefinedKey.valueOf("START_OF_DAY", StartOfDay.class);
    private static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final AttributeQuery EMPTY = new Builder().build();
    private final Map<String, Object> attributes;

    private Attributes(Map<String, Object> map) {
        this.attributes = Collections.unmodifiableMap(new HashMap<String, Object>(map));
    }

    public static AttributeQuery empty() {
        return EMPTY;
    }

    @Override
    public boolean contains(AttributeKey<?> attributeKey) {
        return this.attributes.containsKey(attributeKey.name());
    }

    @Override
    public <A> A get(AttributeKey<A> attributeKey) {
        Object object = this.attributes.get(attributeKey.name());
        if (object == null) {
            throw new NoSuchElementException(attributeKey.name());
        }
        return attributeKey.type().cast(object);
    }

    @Override
    public <A> A get(AttributeKey<A> attributeKey, A a) {
        Object object = this.attributes.get(attributeKey.name());
        if (object == null) {
            return a;
        }
        return attributeKey.type().cast(object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Attributes) {
            Attributes attributes = (Attributes)object;
            return this.attributes.equals(attributes.attributes);
        }
        return false;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.attributes.size() * 32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append(this.attributes);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public Builder() {
        }

        public Builder(Chronology<?> chronology) {
            this.setInternal(CALENDAR_TYPE, CalendarText.extractCalendarType(chronology));
        }

        public Builder setLanguage(Locale locale) {
            this.setInternal(LANGUAGE, locale);
            return this;
        }

        public Builder setTimezone(TZID tZID) {
            this.setInternal(TIMEZONE_ID, tZID);
            return this;
        }

        public Builder setTimezone(String string) {
            this.setTimezone(Timezone.of(string).getID());
            return this;
        }

        public Builder setStdTimezone() {
            return this.setTimezone(Timezone.ofSystem().getID());
        }

        public Builder setCalendarVariant(String string) {
            this.setInternal(CALENDAR_VARIANT, string);
            return this;
        }

        @Deprecated
        public Builder setStartOfDay(StartOfDay startOfDay) {
            this.setInternal(START_OF_DAY, startOfDay);
            return this;
        }

        public Builder set(AttributeKey<Boolean> attributeKey, boolean bl) {
            this.attributes.put(attributeKey.name(), bl);
            return this;
        }

        public Builder set(AttributeKey<Integer> attributeKey, int n) {
            if (attributeKey == PIVOT_YEAR && n < 100) {
                throw new IllegalArgumentException("Pivot year in far past not supported: " + n);
            }
            this.attributes.put(attributeKey.name(), n);
            return this;
        }

        public Builder set(AttributeKey<Character> attributeKey, char c) {
            this.attributes.put(attributeKey.name(), Character.valueOf(c));
            return this;
        }

        public <A extends Enum<A>> Builder set(AttributeKey<A> attributeKey, A a) {
            if (a == null) {
                throw new NullPointerException("Missing attribute value.");
            }
            if (!(a instanceof Enum)) {
                throw new ClassCastException("Enum expected, but found: " + a);
            }
            this.attributes.put(attributeKey.name(), a);
            AttributeKey<A> attributeKey2 = attributeKey;
            if (attributeKey2 == LENIENCY) {
                switch ((Leniency)((Object)Leniency.class.cast(a))) {
                    case STRICT: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)false);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)false);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)false);
                        break;
                    }
                    case SMART: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)true);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)false);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)false);
                        break;
                    }
                    case LAX: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)true);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)true);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)true);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(a.name());
                    }
                }
            }
            return this;
        }

        public Builder setAll(Attributes attributes) {
            this.attributes.putAll(attributes.attributes);
            return this;
        }

        public Builder remove(AttributeKey<?> attributeKey) {
            this.attributes.remove(attributeKey.name());
            return this;
        }

        public Attributes build() {
            return new Attributes(this.attributes);
        }

        private <A> void setInternal(AttributeKey<A> attributeKey, A a) {
            if (a == null) {
                throw new NullPointerException("Missing attribute value.");
            }
            this.attributes.put(attributeKey.name(), a);
        }
    }
}

