/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import tcl.lang.ClassRep;
import tcl.lang.FieldSig;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.JavaImportCmd;
import tcl.lang.JavaInfoCmd;
import tcl.lang.PackageNameException;
import tcl.lang.PropertySig;
import tcl.lang.ReflectException;
import tcl.lang.ReflectObject;
import tcl.lang.TclBoolean;
import tcl.lang.TclClassLoader;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class JavaInvoke {
    private static Object[] EMPTY_ARGS = new Object[0];
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$tcl$lang$TclObject;

    JavaInvoke() {
    }

    static TclObject newInstance(Interp interp, TclObject signature, TclObject[] argv, int startIdx, int count) throws TclException {
        Object sig;
        if (count == 1) {
            sig = signature.toString();
            if (((String)sig).equals("Boolean") || ((String)sig).equals("java.lang.Boolean")) {
                signature = TclString.newInstance("java.lang.Boolean boolean");
            } else if (((String)sig).equals("Integer") || ((String)sig).equals("java.lang.Integer")) {
                signature = TclString.newInstance("java.lang.Integer int");
            } else if (((String)sig).equals("Byte") || ((String)sig).equals("java.lang.Byte")) {
                signature = TclString.newInstance("java.lang.Byte byte");
            } else if (((String)sig).equals("Short") || ((String)sig).equals("java.lang.Short")) {
                signature = TclString.newInstance("java.lang.Short short");
            } else if (((String)sig).equals("Character") || ((String)sig).equals("java.lang.Character")) {
                signature = TclString.newInstance("java.lang.Character char");
            } else if (((String)sig).equals("Long") || ((String)sig).equals("java.lang.Long")) {
                signature = TclString.newInstance("java.lang.Long long");
            } else if (((String)sig).equals("Float") || ((String)sig).equals("java.lang.Float")) {
                signature = TclString.newInstance("java.lang.Float float");
            } else if (((String)sig).equals("Double") || ((String)sig).equals("java.lang.Double")) {
                signature = TclString.newInstance("java.lang.Double double");
            }
        }
        sig = FuncSig.get(interp, null, signature, argv, startIdx, count, false);
        Object javaObj = JavaInvoke.call(interp, ((FuncSig)sig).pkgInvoker, signature, ((FuncSig)sig).func, null, argv, startIdx, count);
        return ReflectObject.newInstance(interp, ((FuncSig)sig).targetCls, javaObj);
    }

    static TclObject callMethod(Interp interp, TclObject reflectObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        Class javaCl = ReflectObject.getClass(interp, reflectObj);
        FuncSig sig = FuncSig.get(interp, javaCl, signature, argv, startIdx, count, false);
        Method method = (Method)sig.func;
        Class<?> rtype = method.getReturnType();
        if (!PkgInvoker.isAccessible(rtype)) {
            throw new TclException(interp, "Return type \"" + JavaInfoCmd.getNameFromClass(rtype) + "\" is not accessible");
        }
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, javaObj, argv, startIdx, count);
        if (rtype == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, rtype, result, convert);
    }

    static TclObject callStaticMethod(Interp interp, TclObject classObj, TclObject signature, TclObject[] argv, int startIdx, int count, boolean convert) throws TclException {
        Class cls = ClassRep.get(interp, classObj);
        FuncSig sig = FuncSig.get(interp, cls, signature, argv, startIdx, count, true);
        Method method = (Method)sig.func;
        Class<?> rtype = method.getReturnType();
        if (!PkgInvoker.isAccessible(rtype)) {
            throw new TclException(interp, "Return type \"" + JavaInfoCmd.getNameFromClass(rtype) + "\" is not accessible");
        }
        Object result = JavaInvoke.call(interp, sig.pkgInvoker, signature, method, null, argv, startIdx, count);
        if (rtype == Void.TYPE) {
            return null;
        }
        return JavaInvoke.wrap(interp, method.getReturnType(), result, convert);
    }

    static Object call(Interp interp, PkgInvoker invoker, TclObject signature, Object func, Object obj, TclObject[] argv, int startIdx, int count) throws TclException {
        Object[] args;
        Class<?>[] paramTypes;
        Constructor cons = null;
        Method method = null;
        boolean isConstructor = func instanceof Constructor;
        if (isConstructor) {
            cons = (Constructor)func;
            paramTypes = cons.getParameterTypes();
        } else {
            method = (Method)func;
            paramTypes = method.getParameterTypes();
        }
        if (count != paramTypes.length) {
            throw new TclException(interp, "wrong # args for calling " + (isConstructor ? "constructor" : "method") + " \"" + signature + "\"");
        }
        if (count == 0) {
            args = EMPTY_ARGS;
        } else {
            args = new Object[count];
            for (int i = 0; i < count; ++i) {
                args[i] = JavaInvoke.convertTclObject(interp, paramTypes[i], argv[i + startIdx]);
            }
        }
        try {
            boolean debug = false;
            Object result = isConstructor ? invoker.invokeConstructor(cons, args) : invoker.invokeMethod(method, obj, args);
            return result;
        }
        catch (InstantiationException e) {
            throw new TclRuntimeError("unexpected abstract class: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible ctor or method: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof TclException) {
                interp.setResult(te.getMessage());
                throw (TclException)te;
            }
            throw new ReflectException(interp, te);
        }
    }

    static final TclObject getField(Interp interp, TclObject classOrObj, TclObject signature, boolean convert) throws TclException {
        return JavaInvoke.getsetField(interp, classOrObj, signature, null, convert, true);
    }

    static final void setField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value) throws TclException {
        JavaInvoke.getsetField(interp, classOrObj, signature, value, false, false);
    }

    static TclObject getsetField(Interp interp, TclObject classOrObj, TclObject signature, TclObject value, boolean convert, boolean isget) throws TclException {
        boolean isStatic;
        Object obj;
        Class cls;
        block14: {
            cls = null;
            obj = null;
            isStatic = false;
            try {
                obj = ReflectObject.get(interp, classOrObj);
            }
            catch (TclException e) {
                try {
                    cls = ClassRep.get(interp, classOrObj);
                }
                catch (TclException e1) {
                    throw new TclException(interp, "unknown class or object \"" + classOrObj + "\"");
                }
                isStatic = true;
                if (PkgInvoker.isAccessible(cls)) break block14;
                JavaInvoke.notAccessibleError(interp, cls);
            }
        }
        if (!isStatic) {
            if (obj == null) {
                throw new TclException(interp, "can't access fields in a null object reference");
            }
            cls = ReflectObject.getClass(interp, classOrObj);
        }
        if (isStatic && isget && signature.toString().equals("class")) {
            return JavaInvoke.wrap(interp, class$java$lang$Class == null ? (class$java$lang$Class = JavaInvoke.class$("java.lang.Class")) : class$java$lang$Class, cls, false);
        }
        FieldSig sig = FieldSig.get(interp, signature, cls);
        Field field = sig.field;
        if (isStatic && !Modifier.isStatic(field.getModifiers())) {
            throw new TclException(interp, "can't access an instance field without an object");
        }
        Class<?> ftype = field.getType();
        if (!PkgInvoker.isAccessible(field.getType())) {
            throw new TclException(interp, "Field type \"" + JavaInfoCmd.getNameFromClass(ftype) + "\" is not accessible");
        }
        if (!isget && Modifier.isFinal(field.getModifiers())) {
            throw new TclException(interp, "can't set final field \"" + signature + "\"");
        }
        try {
            if (isget) {
                return JavaInvoke.wrap(interp, ftype, sig.pkgInvoker.getField(field, obj), convert);
            }
            Object javaValue = JavaInvoke.convertTclObject(interp, ftype, value);
            sig.pkgInvoker.setField(field, obj, javaValue);
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected IllegalAccessException: " + e.getMessage());
        }
    }

    static TclObject getProperty(Interp interp, TclObject reflectObj, TclObject propName, boolean convert) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't get property from null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method readMethod = sig.desc.getReadMethod();
        if (readMethod == null) {
            throw new TclException(interp, "can't get write-only property \"" + propName + "\"");
        }
        try {
            return JavaInvoke.wrap(interp, readMethod.getReturnType(), sig.pkgInvoker.invokeMethod(readMethod, javaObj, EMPTY_ARGS), convert);
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible readMethod: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static void setProperty(Interp interp, TclObject reflectObj, TclObject propName, TclObject value) throws TclException {
        Object javaObj = ReflectObject.get(interp, reflectObj);
        if (javaObj == null) {
            throw new TclException(interp, "can't set property in null object");
        }
        Class javaClass = ReflectObject.getClass(interp, reflectObj);
        PropertySig sig = PropertySig.get(interp, javaClass, propName);
        Method writeMethod = sig.desc.getWriteMethod();
        Class<?> type = sig.desc.getPropertyType();
        if (writeMethod == null) {
            throw new TclException(interp, "can't set read-only property \"" + propName + "\"");
        }
        Object[] args = new Object[]{JavaInvoke.convertTclObject(interp, type, value)};
        try {
            sig.pkgInvoker.invokeMethod(writeMethod, javaObj, args);
        }
        catch (IllegalAccessException e) {
            throw new TclRuntimeError("unexpected inaccessible writeMethod: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new TclRuntimeError("unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(interp, (Throwable)e);
        }
    }

    static Class getClassByName(Interp interp, String clsName) throws TclException {
        int clsName_len;
        Class result = null;
        boolean debug = false;
        StringBuffer prefix_buf = new StringBuffer(64);
        StringBuffer suffix_buf = new StringBuffer(64);
        StringBuffer clsName_buf = new StringBuffer(clsName);
        int dimension = 0;
        while ((clsName_len = clsName_buf.length()) > 2 && clsName_buf.charAt(clsName_len - 2) == '[' && clsName_buf.charAt(clsName_len - 1) == ']') {
            clsName_buf.setLength(clsName_len - 2);
            prefix_buf.append('[');
            ++dimension;
        }
        boolean package_name_exception = false;
        clsName = clsName_buf.toString();
        if (clsName.indexOf(46) == -1) {
            String lname;
            if (dimension > 0) {
                boolean isPrimitive = true;
                if (clsName.equals("int")) {
                    prefix_buf.append('I');
                } else if (clsName.equals("boolean")) {
                    prefix_buf.append('Z');
                } else if (clsName.equals("long")) {
                    prefix_buf.append('J');
                } else if (clsName.equals("float")) {
                    prefix_buf.append('F');
                } else if (clsName.equals("double")) {
                    prefix_buf.append('D');
                } else if (clsName.equals("byte")) {
                    prefix_buf.append('B');
                } else if (clsName.equals("short")) {
                    prefix_buf.append('S');
                } else if (clsName.equals("char")) {
                    prefix_buf.append('C');
                } else {
                    isPrimitive = false;
                }
                if (isPrimitive) {
                    try {
                        return Class.forName(prefix_buf.toString());
                    }
                    catch (ClassNotFoundException e) {
                        throw new TclRuntimeError("unexpected ClassNotFoundException: " + e.getMessage());
                    }
                }
                prefix_buf.append('L');
                suffix_buf.append(';');
            } else {
                if (clsName.equals("int")) {
                    return Integer.TYPE;
                }
                if (clsName.equals("boolean")) {
                    return Boolean.TYPE;
                }
                if (clsName.equals("long")) {
                    return Long.TYPE;
                }
                if (clsName.equals("float")) {
                    return Float.TYPE;
                }
                if (clsName.equals("double")) {
                    return Double.TYPE;
                }
                if (clsName.equals("byte")) {
                    return Byte.TYPE;
                }
                if (clsName.equals("short")) {
                    return Short.TYPE;
                }
                if (clsName.equals("char")) {
                    return Character.TYPE;
                }
            }
            TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
            try {
                lname = prefix_buf + clsName + suffix_buf;
                result = tclClassLoader.loadClass(lname);
            }
            catch (ClassNotFoundException e) {
                result = null;
            }
            catch (PackageNameException e) {
                throw new TclRuntimeError("unexpected PackageNameException :" + e.getMessage());
            }
            if (result == null) {
                boolean inJavaLang = false;
                String fullyqualified = JavaImportCmd.getImport(interp, clsName);
                if (fullyqualified == null) {
                    inJavaLang = true;
                    fullyqualified = "java.lang." + clsName;
                }
                try {
                    lname = prefix_buf + fullyqualified + suffix_buf;
                    result = tclClassLoader.loadClass(lname);
                }
                catch (ClassNotFoundException e) {
                    result = null;
                }
                catch (PackageNameException e) {
                    if (!inJavaLang) {
                        package_name_exception = true;
                    }
                    result = null;
                }
            }
        } else {
            String lname;
            TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
            if (dimension > 0) {
                prefix_buf.append("L");
                suffix_buf.append(";");
            }
            try {
                lname = prefix_buf + clsName + suffix_buf;
                result = tclClassLoader.loadClass(lname);
            }
            catch (ClassNotFoundException e) {
                result = null;
            }
            catch (PackageNameException e) {
                package_name_exception = true;
                result = null;
            }
            if (result == null && clsName.indexOf(36) == -1) {
                ArrayList<String> parts = new ArrayList<String>(5);
                int si = 0;
                int clsNameLength = clsName.length();
                for (int i = 0; i <= clsNameLength; ++i) {
                    if (i != clsNameLength && clsName.charAt(i) != '.') continue;
                    parts.add(clsName.substring(si, i));
                    si = i + 1;
                }
                String toplevel = null;
                String inner = null;
                boolean load_inner = false;
                for (int i = parts.size() - 1; i > 0; --i) {
                    StringBuffer sb = new StringBuffer(64);
                    for (int bi = 0; bi < i; ++bi) {
                        sb.append(parts.get(bi));
                        sb.append('.');
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
                        sb.setLength(sb.length() - 1);
                    }
                    toplevel = sb.toString();
                    sb = new StringBuffer(64);
                    for (int ai = i; ai < parts.size(); ++ai) {
                        sb.append(parts.get(ai));
                        sb.append('$');
                    }
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '$') {
                        sb.setLength(sb.length() - 1);
                    }
                    inner = sb.toString();
                    try {
                        lname = prefix_buf + toplevel + suffix_buf;
                        result = tclClassLoader.loadClass(lname);
                    }
                    catch (ClassNotFoundException e) {
                        result = null;
                    }
                    catch (PackageNameException e) {
                        package_name_exception = true;
                        result = null;
                    }
                    if (result != null) {
                        load_inner = true;
                        break;
                    }
                    if (toplevel.indexOf(46) != -1) continue;
                    String fullyqualified = JavaImportCmd.getImport(interp, toplevel);
                    if (fullyqualified != null) {
                        load_inner = true;
                        toplevel = fullyqualified;
                        break;
                    }
                    fullyqualified = "java.lang." + toplevel;
                    try {
                        lname = prefix_buf + fullyqualified + suffix_buf;
                        result = tclClassLoader.loadClass(lname);
                    }
                    catch (ClassNotFoundException e) {
                        result = null;
                    }
                    catch (PackageNameException e) {
                        result = null;
                    }
                    if (result == null) continue;
                    load_inner = true;
                    toplevel = fullyqualified;
                    break;
                }
                if (load_inner) {
                    try {
                        lname = prefix_buf + toplevel + "$" + inner + suffix_buf;
                        result = tclClassLoader.loadClass(lname);
                    }
                    catch (ClassNotFoundException e) {
                        result = null;
                    }
                    catch (PackageNameException e) {
                        package_name_exception = true;
                        result = null;
                    }
                }
            }
        }
        if (result == null && package_name_exception) {
            throw new TclException(interp, "cannot load new class into java or tcl package");
        }
        if (result == null) {
            throw new TclException(interp, "unknown class \"" + clsName_buf + "\"");
        }
        return result;
    }

    static TclObject convertJavaObject(Interp interp, Class cls, Object javaObj) throws TclException {
        if (javaObj == null) {
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = JavaInvoke.class$("java.lang.String")) : class$java$lang$String)) {
                return TclString.newInstance("");
            }
            return ReflectObject.newInstance(interp, cls, javaObj);
        }
        if (cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaInvoke.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return TclInteger.newInstance((Integer)javaObj);
        }
        if (cls == Long.TYPE || cls == (class$java$lang$Long == null ? (class$java$lang$Long = JavaInvoke.class$("java.lang.Long")) : class$java$lang$Long)) {
            return TclString.newInstance(javaObj.toString());
        }
        if (cls == Short.TYPE || cls == (class$java$lang$Short == null ? (class$java$lang$Short = JavaInvoke.class$("java.lang.Short")) : class$java$lang$Short)) {
            return TclInteger.newInstance(((Short)javaObj).intValue());
        }
        if (cls == Byte.TYPE || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaInvoke.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return TclInteger.newInstance(((Byte)javaObj).intValue());
        }
        if (cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = JavaInvoke.class$("java.lang.Double")) : class$java$lang$Double)) {
            return TclDouble.newInstance((Double)javaObj);
        }
        if (cls == Float.TYPE || cls == (class$java$lang$Float == null ? (class$java$lang$Float = JavaInvoke.class$("java.lang.Float")) : class$java$lang$Float)) {
            return TclDouble.newInstance(((Float)javaObj).doubleValue());
        }
        if (cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaInvoke.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return TclBoolean.newInstance((Boolean)javaObj);
        }
        if (cls == Character.TYPE || cls == (class$java$lang$Character == null ? (class$java$lang$Character = JavaInvoke.class$("java.lang.Character")) : class$java$lang$Character)) {
            return TclString.newInstance(((Character)javaObj).toString());
        }
        if (cls == (class$java$lang$String == null ? (class$java$lang$String = JavaInvoke.class$("java.lang.String")) : class$java$lang$String)) {
            return TclString.newInstance((String)javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    static final Object convertTclObject(Interp interp, Class type, TclObject tclObj) throws TclException {
        Object javaObj = null;
        Class javaClass = null;
        boolean isReflectObj = false;
        try {
            javaObj = ReflectObject.get(interp, tclObj);
            javaClass = ReflectObject.getClass(interp, tclObj);
            isReflectObj = true;
        }
        catch (TclException e) {
            interp.resetResult();
        }
        if (!isReflectObj) {
            if (type == (class$java$lang$String == null ? (class$java$lang$String = JavaInvoke.class$("java.lang.String")) : class$java$lang$String)) {
                return tclObj.toString();
            }
            if (type == (class$java$lang$Object == null ? (class$java$lang$Object = JavaInvoke.class$("java.lang.Object")) : class$java$lang$Object)) {
                return tclObj.toString();
            }
            if (type == Integer.TYPE || type == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaInvoke.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                int jint = JavaInvoke.parseJavaInt(interp, tclObj);
                return new Integer(jint);
            }
            if (type == Boolean.TYPE || type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaInvoke.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return new Boolean(TclBoolean.get(interp, tclObj));
            }
            if (type == Long.TYPE || type == (class$java$lang$Long == null ? (class$java$lang$Long = JavaInvoke.class$("java.lang.Long")) : class$java$lang$Long)) {
                long jlong = JavaInvoke.parseJavaLong(interp, tclObj);
                return new Long(jlong);
            }
            if (type == Float.TYPE || type == (class$java$lang$Float == null ? (class$java$lang$Float = JavaInvoke.class$("java.lang.Float")) : class$java$lang$Float)) {
                double jdouble = TclDouble.get(interp, tclObj);
                float jfloat = (float)jdouble;
                if (jdouble != Double.NaN && jdouble != Double.NEGATIVE_INFINITY && jdouble != Double.POSITIVE_INFINITY && jdouble != 0.0 && (Math.abs(jdouble) > 3.4028234663852886E38 || Math.abs(jdouble) < (double)1.4E-45f)) {
                    throw new TclException(interp, "double value too large to represent in a float");
                }
                return new Float(jfloat);
            }
            if (type == Double.TYPE || type == (class$java$lang$Double == null ? (class$java$lang$Double = JavaInvoke.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(TclDouble.get(interp, tclObj));
            }
            if (type == Byte.TYPE || type == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaInvoke.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                int jint = JavaInvoke.parseJavaInt(interp, tclObj);
                if (jint < -128 || jint > 127) {
                    throw new TclException(interp, "integer value too large to represent in a byte");
                }
                return new Byte((byte)jint);
            }
            if (type == Short.TYPE || type == (class$java$lang$Short == null ? (class$java$lang$Short = JavaInvoke.class$("java.lang.Short")) : class$java$lang$Short)) {
                int jint = JavaInvoke.parseJavaInt(interp, tclObj);
                if (jint < Short.MIN_VALUE || jint > Short.MAX_VALUE) {
                    throw new TclException(interp, "integer value too large to represent in a short");
                }
                return new Short((short)jint);
            }
            if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = JavaInvoke.class$("java.lang.Character")) : class$java$lang$Character)) {
                String str = tclObj.toString();
                if (str.length() != 1) {
                    throw new TclException(interp, "expected character but got \"" + tclObj + "\"");
                }
                return new Character(str.charAt(0));
            }
            if (type == (class$tcl$lang$TclObject == null ? (class$tcl$lang$TclObject = JavaInvoke.class$("tcl.lang.TclObject")) : class$tcl$lang$TclObject)) {
                return tclObj;
            }
            throw new TclException(interp, "\"" + tclObj + "\" is not an object handle of class \"" + JavaInfoCmd.getNameFromClass(type) + "\"");
        }
        if (JavaInvoke.isAssignable(type, javaClass)) {
            return javaObj;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                if (javaObj instanceof Boolean) {
                    return javaObj;
                }
            } else if (type == Character.TYPE) {
                if (javaObj instanceof Character) {
                    return javaObj;
                }
            } else if (type == Byte.TYPE) {
                if (javaObj instanceof Byte) {
                    return javaObj;
                }
            } else if (type == Short.TYPE) {
                if (javaObj instanceof Short) {
                    return javaObj;
                }
            } else if (type == Integer.TYPE) {
                if (javaObj instanceof Integer) {
                    return javaObj;
                }
            } else if (type == Long.TYPE) {
                if (javaObj instanceof Long) {
                    return javaObj;
                }
            } else if (type == Float.TYPE) {
                if (javaObj instanceof Float) {
                    return javaObj;
                }
            } else if (type == Double.TYPE) {
                if (javaObj instanceof Double) {
                    return javaObj;
                }
            } else if (type == Void.TYPE) {
                // empty if block
            }
        }
        if (type == (class$tcl$lang$TclObject == null ? (class$tcl$lang$TclObject = JavaInvoke.class$("tcl.lang.TclObject")) : class$tcl$lang$TclObject)) {
            return tclObj;
        }
        throw new TclException(interp, "expected object of type " + JavaInfoCmd.getNameFromClass(type) + " but got \"" + tclObj + "\" (" + (javaClass == null ? "null" : JavaInfoCmd.getNameFromClass(javaClass)) + ")");
    }

    private static final TclObject wrap(Interp interp, Class cls, Object javaObj, boolean convert) throws TclException {
        if (convert) {
            return JavaInvoke.convertJavaObject(interp, cls, javaObj);
        }
        return ReflectObject.newInstance(interp, cls, javaObj);
    }

    static final boolean isAssignable(Class to_cls, Class from_cls) {
        if (from_cls == null) {
            return !to_cls.isPrimitive();
        }
        return to_cls == from_cls || to_cls.isAssignableFrom(from_cls);
    }

    static void notAccessibleError(Interp interp, Class cls) throws TclException {
        throw new TclException(interp, "Class \"" + JavaInfoCmd.getNameFromClass(cls) + "\" is not accessible");
    }

    static boolean isInnerClass(Class cls) throws TclException {
        String cname = cls.getName();
        return cname.indexOf(36) != -1;
    }

    static int parseJavaInt(Interp interp, TclObject obj) throws TclException {
        int ival;
        int endInd;
        char c;
        int i;
        String srep;
        if (obj.hasNoStringRep() && obj.isIntType()) {
            return TclInteger.get(interp, obj);
        }
        String s = srep = obj.toString();
        int len = s.length();
        boolean isNegative = false;
        for (i = 0; i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c)); ++i) {
        }
        if (i >= len) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        int startInd = i;
        for (endInd = len - 1; endInd > startInd && ((c = s.charAt(endInd)) == ' ' || Character.isWhitespace(c)); --endInd) {
        }
        c = s.charAt(i);
        if (c == '-') {
            isNegative = true;
            ++i;
        }
        if (i >= endInd + 1) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        int radix = 1;
        c = s.charAt(i);
        if (c == '0' && len > 1) {
            c = s.charAt(++i);
            if (len > 2 && (c == 'x' || c == 'X')) {
                radix = 16;
                ++i;
            } else {
                radix = 8;
            }
            s = isNegative ? "-" + s.substring(i, endInd + 1) : s.substring(i, endInd + 1);
        } else {
            if (startInd > 0 || endInd < len - 1) {
                s = s.substring(startInd, endInd + 1);
            }
            radix = 10;
        }
        if (s.length() == 0) {
            throw new TclException(interp, "expected integer but got \"" + srep + "\"");
        }
        try {
            ival = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException nfe) {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (i == 0 && c == '-' || Character.digit(c, radix) != -1) continue;
                throw new TclException(interp, "expected integer but got \"" + srep + "\"");
            }
            throw new TclException(interp, "integer value too large to represent in a int");
        }
        return ival;
    }

    static long parseJavaLong(Interp interp, TclObject obj) throws TclException {
        long lval;
        int endInd;
        char c;
        int i;
        String srep;
        if (obj.hasNoStringRep() && obj.isIntType()) {
            return TclInteger.get(interp, obj);
        }
        String s = srep = obj.toString();
        int len = s.length();
        boolean isNegative = false;
        for (i = 0; i < len && ((c = s.charAt(i)) == ' ' || Character.isWhitespace(c)); ++i) {
        }
        if (i >= len) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        int startInd = i;
        for (endInd = len - 1; endInd > startInd && ((c = s.charAt(endInd)) == ' ' || Character.isWhitespace(c)); --endInd) {
        }
        c = s.charAt(i);
        if (c == '-') {
            isNegative = true;
            ++i;
        }
        if (i >= endInd + 1) {
            throw new TclException(interp, "expected integer but got \"" + s + "\"");
        }
        int radix = 1;
        c = s.charAt(i);
        if (c == '0' && len > 1) {
            c = s.charAt(++i);
            if (len > 2 && (c == 'x' || c == 'X')) {
                radix = 16;
                ++i;
            } else {
                radix = 8;
            }
            s = isNegative ? "-" + s.substring(i, endInd + 1) : s.substring(i, endInd + 1);
        } else {
            if (startInd > 0 || endInd < len - 1) {
                s = s.substring(startInd, endInd + 1);
            }
            radix = 10;
        }
        if (s.length() == 0) {
            throw new TclException(interp, "expected integer but got \"" + srep + "\"");
        }
        try {
            lval = Long.parseLong(s, radix);
        }
        catch (NumberFormatException nfe) {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (i == 0 && c == '-' || Character.digit(c, radix) != -1) continue;
                throw new TclException(interp, "expected integer but got \"" + srep + "\"");
            }
            throw new TclException(interp, "integer value too large to represent in a long");
        }
        return lval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

