/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class AvoidThrowingNullPointerExceptionRule
extends AbstractJavaRulechainRule {
    public AvoidThrowingNullPointerExceptionRule() {
        super(ASTThrowStatement.class, new Class[0]);
    }

    public Object visit(ASTThrowStatement throwStmt, Object data) {
        JVariableSymbol sym;
        ASTExpression thrown = throwStmt.getExpr();
        if (TypeTestUtil.isA(NullPointerException.class, (TypeNode)thrown)) {
            this.asCtx(data).addViolation((Node)throwStmt);
        } else if (thrown instanceof ASTVariableAccess && (sym = ((ASTVariableAccess)thrown).getReferencedSym()) instanceof JLocalVariableSymbol && this.hasNpeValue((ASTVariableAccess)thrown)) {
            this.asCtx(data).addViolation((Node)throwStmt);
        }
        return null;
    }

    private boolean hasNpeValue(ASTVariableAccess thrown) {
        DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(thrown.getRoot());
        DataflowPass.ReachingDefinitionSet reaching = dataflow.getReachingDefinitions(thrown);
        if (reaching.isNotFullyKnown()) {
            return false;
        }
        for (DataflowPass.AssignmentEntry it : reaching.getReaching()) {
            if (TypeTestUtil.isExactlyA(NullPointerException.class, it.getRhsType())) continue;
            return false;
        }
        return true;
    }
}

