/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GuardLogStatementRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> LOG_LEVELS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"logLevels").desc("LogLevels to guard")).defaultValues((Object)"trace", (Object[])new String[]{"debug", "info", "warn", "error", "log", "finest", "finer", "fine", "info", "warning", "severe"}).build();
    private static final PropertyDescriptor<List<String>> GUARD_METHODS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"guardsMethods").desc("Method use to guard the log statement")).defaultValues((Object)"isTraceEnabled", (Object[])new String[]{"isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "isLoggable"}).build();
    private final Map<String, String> guardStmtByLogLevel = new HashMap<String, String>(12);
    private static final String JAVA_UTIL_LOG_METHOD = "log";
    private static final String JAVA_UTIL_LOG_GUARD_METHOD = "isLoggable";

    public GuardLogStatementRule() {
        super(ASTExpressionStatement.class, new Class[0]);
        this.definePropertyDescriptor(LOG_LEVELS);
        this.definePropertyDescriptor(GUARD_METHODS);
    }

    public void start(RuleContext ctx) {
        this.extractProperties();
    }

    public Object visit(ASTExpressionStatement node, Object data) {
        ASTExpression expr = node.getExpr();
        if (!(expr instanceof ASTMethodCall)) {
            return null;
        }
        ASTMethodCall methodCall = (ASTMethodCall)expr;
        String logLevel = this.getLogLevelName(methodCall);
        if (logLevel != null && this.guardStmtByLogLevel.containsKey(logLevel) && this.needsGuard(methodCall) && !this.hasGuard(methodCall, logLevel)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return null;
    }

    private boolean needsGuard(ASTMethodCall node) {
        if (node.getArguments().isEmpty()) {
            return false;
        }
        int messageArg = this.getMessageArgIndex(node);
        ASTExpression messageExpr = (ASTExpression)node.getArguments().get(messageArg);
        if (!GuardLogStatementRule.isDirectAccess(messageExpr) && !messageExpr.isCompileTimeConstant()) {
            return true;
        }
        return !this.areAdditionalParamsDirectAccess(node, messageArg + 1);
    }

    private boolean hasGuard(ASTMethodCall node, String logLevel) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.ancestors(ASTIfStatement.class).first();
        if (ifStatement == null) {
            return false;
        }
        for (ASTMethodCall maybeAGuardCall : ifStatement.getCondition().descendantsOrSelf().filterIs(ASTMethodCall.class)) {
            String guardMethodName = maybeAGuardCall.getMethodName();
            if (!this.guardStmtByLogLevel.get(logLevel).contains(guardMethodName)) continue;
            if (JAVA_UTIL_LOG_GUARD_METHOD.equals(guardMethodName)) {
                if (!logLevel.equals(this.getJutilLogLevelInFirstArg(maybeAGuardCall))) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private @Nullable String getLogLevelName(ASTMethodCall methodCall) {
        String methodName = methodCall.getMethodName();
        if (!JAVA_UTIL_LOG_METHOD.equals(methodName)) {
            return methodName;
        }
        return this.getJutilLogLevelInFirstArg(methodCall);
    }

    private int getMessageArgIndex(ASTMethodCall methodCall) {
        String methodName = methodCall.getMethodName();
        if (JAVA_UTIL_LOG_METHOD.equals(methodName)) {
            return 1;
        }
        return 0;
    }

    private @Nullable String getJutilLogLevelInFirstArg(ASTMethodCall methodCall) {
        ASTExpression firstArg = (ASTExpression)methodCall.getArguments().toStream().get(0);
        if (TypeTestUtil.isA("java.util.logging.Level", (TypeNode)firstArg) && firstArg instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            return ((ASTAssignableExpr.ASTNamedReferenceExpr)firstArg).getName().toLowerCase(Locale.ROOT);
        }
        return null;
    }

    private boolean areAdditionalParamsDirectAccess(ASTMethodCall call, int messageArgIndex) {
        return call.getArguments().toStream().drop(messageArgIndex).all(GuardLogStatementRule::isDirectAccess);
    }

    private static boolean isDirectAccess(ASTExpression it) {
        boolean isPermittedType;
        boolean bl = isPermittedType = it instanceof ASTLiteral || it instanceof ASTLambdaExpression || it instanceof ASTVariableAccess || it instanceof ASTThisExpression || it instanceof ASTMethodReference || it instanceof ASTFieldAccess || it instanceof ASTArrayAccess;
        if (!isPermittedType) {
            return false;
        }
        if (it instanceof QualifiableExpression) {
            ASTExpression qualifier = ((QualifiableExpression)it).getQualifier();
            if (it instanceof ASTArrayAccess && !GuardLogStatementRule.isDirectAccess(((ASTArrayAccess)it).getIndexExpression())) {
                return false;
            }
            return qualifier == null || qualifier instanceof ASTTypeExpression || GuardLogStatementRule.isDirectAccess(qualifier);
        }
        return true;
    }

    private void extractProperties() {
        if (this.guardStmtByLogLevel.isEmpty()) {
            ArrayList<String> logLevels = new ArrayList<String>((Collection)super.getProperty(LOG_LEVELS));
            ArrayList<String> guardMethods = new ArrayList<String>((Collection)super.getProperty(GUARD_METHODS));
            if (guardMethods.isEmpty() && !logLevels.isEmpty()) {
                throw new IllegalArgumentException("Can't specify logLevels without specifying guardMethods.");
            }
            if (logLevels.size() > guardMethods.size()) {
                int needed = logLevels.size() - guardMethods.size();
                String lastGuard = (String)guardMethods.get(guardMethods.size() - 1);
                for (int i = 0; i < needed; ++i) {
                    guardMethods.add(lastGuard);
                }
            }
            if (logLevels.size() != guardMethods.size()) {
                throw new IllegalArgumentException("For each logLevel a guardMethod must be specified.");
            }
            this.buildGuardStatementMap(logLevels, guardMethods);
        }
    }

    private void buildGuardStatementMap(List<String> logLevels, List<String> guardMethods) {
        for (int i = 0; i < logLevels.size(); ++i) {
            String logLevel = logLevels.get(i);
            if (this.guardStmtByLogLevel.containsKey(logLevel)) {
                String combinedGuard = this.guardStmtByLogLevel.get(logLevel);
                combinedGuard = combinedGuard + "|" + guardMethods.get(i);
                this.guardStmtByLogLevel.put(logLevel, combinedGuard);
                continue;
            }
            this.guardStmtByLogLevel.put(logLevel, guardMethods.get(i));
        }
    }
}

