/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.MapSymResolver;
import org.apache.commons.lang3.mutable.MutableInt;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AstSymbolMakerVisitor
extends JavaVisitorBase<AstSymFactory, Void> {
    private static final String NO_CANONICAL_NAME = "<impossible/name>";
    private final Deque<Map<String, Integer>> currentLocalIndices = new ArrayDeque<Map<String, Integer>>();
    private final Deque<MutableInt> anonymousCounters = new ArrayDeque<MutableInt>();
    private final Deque<String> enclosingBinaryNames = new ArrayDeque<String>();
    private final Deque<String> enclosingCanonicalNames = new ArrayDeque<String>();
    private final Deque<JTypeParameterOwnerSymbol> enclosingSymbols = new ArrayDeque<JTypeParameterOwnerSymbol>();
    private final String packageName;
    private final Map<String, JClassSymbol> byCanonicalName = new HashMap<String, JClassSymbol>();
    private final Map<String, JClassSymbol> byBinaryName = new HashMap<String, JClassSymbol>();

    AstSymbolMakerVisitor(ASTCompilationUnit node) {
        this.packageName = node.getPackageName();
    }

    public SymbolResolver makeKnownSymbolResolver() {
        return new MapSymResolver(this.byCanonicalName, this.byBinaryName);
    }

    @Override
    public Void visit(ASTVariableId node, AstSymFactory data) {
        if (this.isTrueLocalVar(node)) {
            data.setLocalVarSymbol(node);
        } else assert (node.getSymbol() != null) : "Symbol was null for " + node;
        return (Void)super.visit(node, (Object)data);
    }

    private boolean isTrueLocalVar(ASTVariableId node) {
        return !node.isField() && !node.isEnumConstant() && !node.isRecordComponent() && !(node.getParent() instanceof ASTFormalParameter);
    }

    @Override
    public Void visitTypeDecl(ASTTypeDeclaration node, AstSymFactory data) {
        String binaryName = this.makeBinaryName(node);
        @Nullable String canonicalName = this.makeCanonicalName(node, binaryName);
        InternalApiBridge.setQname(node, binaryName, canonicalName);
        JClassSymbol sym = data.setClassSymbol(this.enclosingSymbols.peek(), node);
        this.byBinaryName.put(binaryName, sym);
        if (canonicalName != null) {
            this.byCanonicalName.put(canonicalName, sym);
        }
        this.enclosingBinaryNames.push(binaryName);
        this.enclosingCanonicalNames.push(canonicalName == null ? NO_CANONICAL_NAME : canonicalName);
        this.enclosingSymbols.push(sym);
        this.anonymousCounters.push(new MutableInt(0));
        this.currentLocalIndices.push(new HashMap());
        this.visitChildren((Node)node, data);
        this.currentLocalIndices.pop();
        this.anonymousCounters.pop();
        this.enclosingSymbols.pop();
        this.enclosingBinaryNames.pop();
        this.enclosingCanonicalNames.pop();
        return null;
    }

    private @NonNull String makeBinaryName(ASTTypeDeclaration node) {
        String simpleName = node.getSimpleName();
        if (node.isLocal()) {
            simpleName = AstSymbolMakerVisitor.getNextIndexFromHistogram(this.currentLocalIndices.getFirst(), node.getSimpleName(), 1) + simpleName;
        } else if (node.isAnonymous()) {
            simpleName = "" + this.anonymousCounters.getFirst().incrementAndGet();
        }
        String enclosing = this.enclosingBinaryNames.peek();
        return enclosing != null ? enclosing + "$" + simpleName : (this.packageName.isEmpty() ? simpleName : this.packageName + "." + simpleName);
    }

    private @Nullable String makeCanonicalName(ASTTypeDeclaration node, String binaryName) {
        if (node.isAnonymous() || node.isLocal()) {
            return null;
        }
        if (this.enclosingCanonicalNames.isEmpty()) {
            return binaryName;
        }
        String enclCanon = this.enclosingCanonicalNames.getFirst();
        return NO_CANONICAL_NAME.equals(enclCanon) ? null : enclCanon + '.' + node.getSimpleName();
    }

    @Override
    public Void visitMethodOrCtor(ASTExecutableDeclaration node, AstSymFactory data) {
        this.enclosingSymbols.push(node.getSymbol());
        this.visitChildren((Node)node, data);
        this.enclosingSymbols.pop();
        return null;
    }

    private static <T> int getNextIndexFromHistogram(Map<T, Integer> histogram, T key, int startIndex) {
        Integer count = histogram.get(key);
        if (count == null) {
            histogram.put(key, startIndex);
            return startIndex;
        }
        histogram.put(key, count + 1);
        return count + 1;
    }
}

