/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class UnnecessaryConstructorRule
extends AbstractIgnoredAnnotationRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTEnumDeclaration.class, (Class[])new Class[]{ASTClassDeclaration.class});
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Arrays.asList("javax.inject.Inject", "com.google.inject.Inject", "org.springframework.beans.factory.annotation.Autowired");
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (node.isRegularClass()) {
            this.checkClassOrEnum(node, data);
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkClassOrEnum(node, data);
        return data;
    }

    private void checkClassOrEnum(ASTTypeDeclaration node, Object data) {
        List ctors = node.getDeclarations(ASTConstructorDeclaration.class).take(2).toList();
        if (ctors.size() == 1 && this.isExplicitDefaultConstructor(node, (ASTConstructorDeclaration)ctors.get(0))) {
            this.asCtx(data).addViolation((Node)ctors.get(0));
        }
    }

    private boolean isExplicitDefaultConstructor(ASTTypeDeclaration declarator, ASTConstructorDeclaration ctor) {
        return ctor.getArity() == 0 && !this.hasIgnoredAnnotation(ctor) && this.hasDefaultCtorVisibility(declarator, ctor) && this.isEmptyBlock(ctor.getBody()) && ctor.getThrowsList() == null;
    }

    private boolean isEmptyBlock(ASTBlock body) {
        ASTStatement stmt;
        if (body.size() == 0) {
            return true;
        }
        if (body.size() == 1 && (stmt = (ASTStatement)body.get(0)) instanceof ASTExplicitConstructorInvocation) {
            ASTExplicitConstructorInvocation superCall = (ASTExplicitConstructorInvocation)stmt;
            return superCall.isSuper() && superCall.getArgumentCount() == 0;
        }
        return false;
    }

    private boolean hasDefaultCtorVisibility(ASTTypeDeclaration node, ASTConstructorDeclaration cons) {
        if (node instanceof ASTClassDeclaration) {
            return node.getVisibility() == cons.getVisibility();
        }
        if (node instanceof ASTEnumDeclaration) {
            return cons.getVisibility() == ModifierOwner.Visibility.V_PRIVATE;
        }
        return false;
    }
}

