/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.AssertionUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

strictfp final class ConstantFolder
extends JavaVisitorBase<Void, Object> {
    static final ConstantFolder INSTANCE = new ConstantFolder();
    private static final Pair<Object, Object> FAILED_BIN_PROMOTION = Pair.of(null, null);

    private ConstantFolder() {
    }

    @Override
    public Object visitJavaNode(JavaNode node, Void data) {
        return null;
    }

    @Override
    public @NonNull Number visitLiteral(ASTLiteral num, Void data) {
        throw new AssertionError((Object)"Literal nodes implement getConstValue directly");
    }

    @Override
    public Object visit(ASTVariableAccess node, Void data) {
        return this.fetchConstFieldReference(node);
    }

    @Override
    public Object visit(ASTFieldAccess node, Void data) {
        return this.fetchConstFieldReference(node);
    }

    private @Nullable Object fetchConstFieldReference(ASTAssignableExpr.ASTNamedReferenceExpr node) {
        JVariableSymbol symbol = node.getReferencedSym();
        if (symbol instanceof JFieldSymbol) {
            return ((JFieldSymbol)symbol).getConstValue();
        }
        return null;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Void data) {
        Object condition = node.getCondition().getConstValue();
        if (condition instanceof Boolean) {
            Object thenValue = node.getThenBranch().getConstValue();
            Object elseValue = node.getElseBranch().getConstValue();
            if (thenValue == null || elseValue == null) {
                return null;
            }
            if (((Boolean)condition).booleanValue()) {
                return thenValue;
            }
            return elseValue;
        }
        return null;
    }

    @Override
    public Object visit(ASTCastExpression node, Void data) {
        JTypeMirror t = node.getCastType().getTypeMirror();
        if (t.isNumeric()) {
            return ConstantFolder.numericCoercion(node.getOperand().getConstValue(), t);
        }
        if (TypeTestUtil.isExactlyA(String.class, (TypeNode)node.getCastType())) {
            return ConstantFolder.stringCoercion(node.getOperand().getConstValue());
        }
        return null;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Void data) {
        UnaryOp operator = node.getOperator();
        if (!operator.isPure()) {
            return null;
        }
        ASTExpression operand = node.getOperand();
        Object operandValue = operand.getConstValue();
        if (operandValue == null) {
            return null;
        }
        switch (operator) {
            case UNARY_PLUS: {
                return ConstantFolder.unaryPromotion(operandValue);
            }
            case UNARY_MINUS: {
                Number promoted = ConstantFolder.unaryPromotion(operandValue);
                if (promoted == null) {
                    return null;
                }
                if (promoted instanceof Integer) {
                    return -promoted.intValue();
                }
                if (promoted instanceof Long) {
                    return -promoted.longValue();
                }
                if (promoted instanceof Float) {
                    return Float.valueOf(-promoted.floatValue());
                }
                assert (promoted instanceof Double);
                return -promoted.doubleValue();
            }
            case COMPLEMENT: {
                Number promoted = ConstantFolder.unaryPromotion(operandValue);
                if (promoted instanceof Integer) {
                    return ~promoted.intValue();
                }
                if (promoted instanceof Long) {
                    return promoted.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                }
                return null;
            }
            case NEGATION: {
                return ConstantFolder.booleanInvert(operandValue);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public Object visit(ASTInfixExpression node, Void data) {
        Object left = node.getLeftOperand().getConstValue();
        Object right = node.getRightOperand().getConstValue();
        if (left == null || right == null) {
            return null;
        }
        switch (node.getOperator()) {
            case CONDITIONAL_OR: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    return (Boolean)left != false || (Boolean)right != false;
                }
                return null;
            }
            case CONDITIONAL_AND: {
                if (left instanceof Boolean && right instanceof Boolean) {
                    return (Boolean)left != false && (Boolean)right != false;
                }
                return null;
            }
            case OR: {
                Pair<Object, Object> promoted = ConstantFolder.booleanAwareBinaryPromotion(left, right);
                left = promoted.getLeft();
                right = promoted.getRight();
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) | ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) | ConstantFolder.longValue(right);
                }
                if (left instanceof Boolean) {
                    return ConstantFolder.booleanValue(left) | ConstantFolder.booleanValue(right);
                }
                return null;
            }
            case XOR: {
                Pair<Object, Object> promoted = ConstantFolder.booleanAwareBinaryPromotion(left, right);
                left = promoted.getLeft();
                right = promoted.getRight();
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) ^ ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) ^ ConstantFolder.longValue(right);
                }
                if (left instanceof Boolean) {
                    return ConstantFolder.booleanValue(left) ^ ConstantFolder.booleanValue(right);
                }
                return null;
            }
            case AND: {
                Pair<Object, Object> promoted = ConstantFolder.booleanAwareBinaryPromotion(left, right);
                left = promoted.getLeft();
                right = promoted.getRight();
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) & ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) & ConstantFolder.longValue(right);
                }
                if (left instanceof Boolean) {
                    return ConstantFolder.booleanValue(left) & ConstantFolder.booleanValue(right);
                }
                return null;
            }
            case EQ: {
                return ConstantFolder.eqResult(left, right);
            }
            case NE: {
                return ConstantFolder.booleanInvert(ConstantFolder.eqResult(left, right));
            }
            case LE: {
                return ConstantFolder.compLE(left, right);
            }
            case GT: {
                return ConstantFolder.booleanInvert(ConstantFolder.compLE(left, right));
            }
            case LT: {
                return ConstantFolder.compLT(left, right);
            }
            case GE: {
                return ConstantFolder.booleanInvert(ConstantFolder.compLT(left, right));
            }
            case INSTANCEOF: {
                return null;
            }
            case LEFT_SHIFT: {
                left = ConstantFolder.unaryPromotion(left);
                right = ConstantFolder.unaryPromotion(right);
                if (!(right instanceof Integer) && !(right instanceof Long)) {
                    return null;
                }
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) << ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) << ConstantFolder.intValue(right);
                }
                return null;
            }
            case RIGHT_SHIFT: {
                left = ConstantFolder.unaryPromotion(left);
                right = ConstantFolder.unaryPromotion(right);
                if (!(right instanceof Integer) && !(right instanceof Long)) {
                    return null;
                }
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) >> ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) >> ConstantFolder.intValue(right);
                }
                return null;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                left = ConstantFolder.unaryPromotion(left);
                right = ConstantFolder.unaryPromotion(right);
                if (!(right instanceof Integer) && !(right instanceof Long)) {
                    return null;
                }
                if (left instanceof Integer) {
                    return ConstantFolder.intValue(left) >>> ConstantFolder.intValue(right);
                }
                if (left instanceof Long) {
                    return ConstantFolder.longValue(left) >>> ConstantFolder.intValue(right);
                }
                return null;
            }
            case ADD: {
                if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
                    Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
                    left = promoted.getLeft();
                    right = promoted.getRight();
                    if (left instanceof Integer) {
                        return ConstantFolder.intValue(left) + ConstantFolder.intValue(right);
                    }
                    if (left instanceof Long) {
                        return ConstantFolder.longValue(left) + ConstantFolder.longValue(right);
                    }
                    if (left instanceof Float) {
                        return Float.valueOf(ConstantFolder.floatValue(left) + ConstantFolder.floatValue(right));
                    }
                    return ConstantFolder.doubleValue(left) + ConstantFolder.doubleValue(right);
                }
                if (left instanceof String) {
                    return (String)left + right;
                }
                if (right instanceof String) {
                    return left + (String)right;
                }
                return null;
            }
            case SUB: {
                if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
                    Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
                    left = promoted.getLeft();
                    right = promoted.getRight();
                    if (left instanceof Integer) {
                        return ConstantFolder.intValue(left) - ConstantFolder.intValue(right);
                    }
                    if (left instanceof Long) {
                        return ConstantFolder.longValue(left) - ConstantFolder.longValue(right);
                    }
                    if (left instanceof Float) {
                        return Float.valueOf(ConstantFolder.floatValue(left) - ConstantFolder.floatValue(right));
                    }
                    return ConstantFolder.doubleValue(left) - ConstantFolder.doubleValue(right);
                }
                return null;
            }
            case MUL: {
                if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
                    Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
                    left = promoted.getLeft();
                    right = promoted.getRight();
                    if (left instanceof Integer) {
                        return ConstantFolder.intValue(left) * ConstantFolder.intValue(right);
                    }
                    if (left instanceof Long) {
                        return ConstantFolder.longValue(left) * ConstantFolder.longValue(right);
                    }
                    if (left instanceof Float) {
                        return Float.valueOf(ConstantFolder.floatValue(left) * ConstantFolder.floatValue(right));
                    }
                    return ConstantFolder.doubleValue(left) * ConstantFolder.doubleValue(right);
                }
                return null;
            }
            case DIV: {
                if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
                    Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
                    left = promoted.getLeft();
                    right = promoted.getRight();
                    if (left instanceof Integer) {
                        return ConstantFolder.intValue(left) / ConstantFolder.intValue(right);
                    }
                    if (left instanceof Long) {
                        return ConstantFolder.longValue(left) / ConstantFolder.longValue(right);
                    }
                    if (left instanceof Float) {
                        return Float.valueOf(ConstantFolder.floatValue(left) / ConstantFolder.floatValue(right));
                    }
                    return ConstantFolder.doubleValue(left) / ConstantFolder.doubleValue(right);
                }
                return null;
            }
            case MOD: {
                if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
                    Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
                    left = promoted.getLeft();
                    right = promoted.getRight();
                    if (left instanceof Integer) {
                        return ConstantFolder.intValue(left) % ConstantFolder.intValue(right);
                    }
                    if (left instanceof Long) {
                        return ConstantFolder.longValue(left) % ConstantFolder.longValue(right);
                    }
                    if (left instanceof Float) {
                        return Float.valueOf(ConstantFolder.floatValue(left) % ConstantFolder.floatValue(right));
                    }
                    return ConstantFolder.doubleValue(left) % ConstantFolder.doubleValue(right);
                }
                return null;
            }
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unknown operator in " + node));
    }

    private static @Nullable Object compLE(Object left, Object right) {
        if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
            Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
            left = promoted.getLeft();
            right = promoted.getRight();
            if (left instanceof Integer) {
                return ConstantFolder.intValue(left) <= ConstantFolder.intValue(right);
            }
            if (left instanceof Long) {
                return ConstantFolder.longValue(left) <= ConstantFolder.longValue(right);
            }
            if (left instanceof Float) {
                return ConstantFolder.floatValue(left) <= ConstantFolder.floatValue(right);
            }
            if (left instanceof Double) {
                return ConstantFolder.doubleValue(left) <= ConstantFolder.doubleValue(right);
            }
        }
        return null;
    }

    private static @Nullable Boolean compLT(Object left, Object right) {
        if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
            Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
            left = promoted.getLeft();
            right = promoted.getRight();
            if (left instanceof Integer) {
                return ConstantFolder.intValue(left) < ConstantFolder.intValue(right);
            }
            if (left instanceof Long) {
                return ConstantFolder.longValue(left) < ConstantFolder.longValue(right);
            }
            if (left instanceof Float) {
                return ConstantFolder.floatValue(left) < ConstantFolder.floatValue(right);
            }
            if (left instanceof Double) {
                return ConstantFolder.doubleValue(left) < ConstantFolder.doubleValue(right);
            }
        }
        return null;
    }

    private static @Nullable Boolean booleanInvert(@Nullable Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b == false;
        }
        return null;
    }

    private static @Nullable Boolean eqResult(Object left, Object right) {
        if (ConstantFolder.isConvertibleToNumber(left) && ConstantFolder.isConvertibleToNumber(right)) {
            Pair<Object, Object> promoted = ConstantFolder.binaryNumericPromotion(left, right);
            return promoted.getLeft().equals(promoted.getRight());
        }
        return null;
    }

    private static boolean isConvertibleToNumber(Object o) {
        return o instanceof Number || o instanceof Character;
    }

    private static @Nullable Number unaryPromotion(Object t) {
        if (t instanceof Character) {
            return (int)((Character)t).charValue();
        }
        if (t instanceof Number) {
            if (t instanceof Byte || t instanceof Short) {
                return ConstantFolder.intValue(t);
            }
            return (Number)t;
        }
        return null;
    }

    private static Pair<Object, Object> binaryNumericPromotion(Object left, Object right) {
        left = ConstantFolder.projectCharOntoInt(left);
        right = ConstantFolder.projectCharOntoInt(right);
        if (left instanceof Double || right instanceof Double) {
            return Pair.of((Object)ConstantFolder.doubleValue(left), (Object)ConstantFolder.doubleValue(right));
        }
        if (left instanceof Float || right instanceof Float) {
            return Pair.of((Object)Float.valueOf(ConstantFolder.floatValue(left)), (Object)Float.valueOf(ConstantFolder.floatValue(right)));
        }
        if (left instanceof Long || right instanceof Long) {
            return Pair.of((Object)ConstantFolder.longValue(left), (Object)ConstantFolder.longValue(right));
        }
        return Pair.of((Object)ConstantFolder.intValue(left), (Object)ConstantFolder.intValue(right));
    }

    private static Pair<Object, Object> booleanAwareBinaryPromotion(Object left, Object right) {
        if (left instanceof Boolean || right instanceof Boolean) {
            if (left instanceof Boolean && right instanceof Boolean) {
                return Pair.of((Object)left, (Object)right);
            }
            return FAILED_BIN_PROMOTION;
        }
        if (!ConstantFolder.isConvertibleToNumber(left) || !ConstantFolder.isConvertibleToNumber(right)) {
            return FAILED_BIN_PROMOTION;
        }
        return ConstantFolder.binaryNumericPromotion(left, right);
    }

    private static Object projectCharOntoInt(Object v) {
        if (v instanceof Character) {
            return (int)((Character)v).charValue();
        }
        return v;
    }

    private static Object numericCoercion(Object v, JTypeMirror target) {
        v = ConstantFolder.projectCharOntoInt(v);
        if (target.isNumeric() && v instanceof Number) {
            switch (((JPrimitiveType)target).getKind()) {
                case BOOLEAN: {
                    throw new AssertionError((Object)"unreachable");
                }
                case CHAR: {
                    return Character.valueOf((char)ConstantFolder.intValue(v));
                }
                case BYTE: {
                    return (byte)ConstantFolder.intValue(v);
                }
                case SHORT: {
                    return (short)ConstantFolder.intValue(v);
                }
                case INT: {
                    return ConstantFolder.intValue(v);
                }
                case LONG: {
                    return ConstantFolder.longValue(v);
                }
                case FLOAT: {
                    return Float.valueOf(ConstantFolder.floatValue(v));
                }
                case DOUBLE: {
                    return ConstantFolder.doubleValue(v);
                }
            }
            throw AssertionUtil.shouldNotReachHere((String)"exhaustive enum");
        }
        return null;
    }

    private static Object stringCoercion(Object v) {
        if (v instanceof String) {
            return v;
        }
        return null;
    }

    private static boolean booleanValue(Object x) {
        return (Boolean)x;
    }

    private static int intValue(Object x) {
        return ((Number)x).intValue();
    }

    private static long longValue(Object x) {
        return ((Number)x).longValue();
    }

    private static float floatValue(Object x) {
        return ((Number)x).floatValue();
    }

    private static double doubleValue(Object x) {
        return ((Number)x).doubleValue();
    }
}

