/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.qname;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;
import net.sourceforge.pmd.lang.java.qname.ImmutableList;
import net.sourceforge.pmd.lang.java.qname.JavaOperationQualifiedName;
import net.sourceforge.pmd.lang.java.qname.JavaTypeQualifiedName;
import org.apache.commons.lang3.StringUtils;

public final class QualifiedNameFactory {
    private static final String LAMBDA_PATTERN = "lambda\\$(\\w++)?\\$\\d++";
    private static final Pattern COMPILED_LAMBDA_PATTERN = Pattern.compile("lambda\\$(\\w++)?\\$\\d++");
    private static final Pattern FORMAT = Pattern.compile("((\\w++\\.)*)                       # packages\n(                         # classes\n  (\\w++)                 # primary class\n  (    \\$                   # separator\n    \\d*+                 # optional local/anonymous class index\n    ([a-zA-Z]\\w*+)?      # regular class name, absent for anonymous class\n  )*)(                         # optional operation suffix\n  \\#  (   lambda\\$(\\w++)?\\$\\d++ # name of a lambda\n  |      (\\w++)               # method name\n    \\(    (                     # parameters\n      (\\w++)      (,\\040\\w++)*      #   is a space\n    )?    \\)  ))?", 4);
    private static final int PACKAGES_GROUP_INDEX = 1;
    private static final int CLASSES_GROUP_INDEX = 3;
    private static final int OPERATION_GROUP_INDEX = 7;
    private static final Pattern LOCAL_INDEX_PATTERN = Pattern.compile("(\\d+)(\\D\\w+)");

    private QualifiedNameFactory() {
    }

    public static JavaTypeQualifiedName ofClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        if (name.indexOf(46) < 0) {
            name = '.' + name;
        }
        return (JavaTypeQualifiedName)QualifiedNameFactory.ofStringWithClassLoader(name, clazz.getClassLoader());
    }

    public static JavaQualifiedName ofString(String name) {
        return QualifiedNameFactory.ofStringWithClassLoader(name, null);
    }

    private static JavaQualifiedName ofStringWithClassLoader(String name, ClassLoader classLoader) {
        Matcher matcher = FORMAT.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        ImmutableList<String> packages = StringUtils.isBlank((CharSequence)matcher.group(1)) ? ImmutableList.ListFactory.emptyList() : ImmutableList.ListFactory.split(matcher.group(1), "\\.");
        String operation = matcher.group(7) == null ? null : matcher.group(7).substring(1);
        boolean isLambda = operation != null && COMPILED_LAMBDA_PATTERN.matcher(operation).matches();
        ImmutableList<String> indexAndClasses = ImmutableList.ListFactory.split(matcher.group(3), "\\$");
        ImmutableList<Integer> localIndices = ImmutableList.ListFactory.emptyList();
        ImmutableList<String> classes = ImmutableList.ListFactory.emptyList();
        for (String clazz : indexAndClasses.reverse()) {
            Matcher localIndexMatcher = LOCAL_INDEX_PATTERN.matcher(clazz);
            if (localIndexMatcher.matches()) {
                localIndices = localIndices.prepend(Integer.parseInt(localIndexMatcher.group(1)));
                classes = classes.prepend(localIndexMatcher.group(2));
                continue;
            }
            localIndices = localIndices.prepend(-1);
            classes = classes.prepend(clazz);
        }
        JavaTypeQualifiedName parent = new JavaTypeQualifiedName(packages, classes, localIndices, classLoader);
        return operation == null ? parent : new JavaOperationQualifiedName(parent, operation, isLambda);
    }
}

