/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJUnitRule;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class TestClassWithoutTestCasesRule
extends AbstractJavaRule {
    public TestClassWithoutTestCasesRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceBody.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceBody node, Object data) {
        if (AbstractJUnitRule.isTestClass(node)) {
            List declarations = node.findChildrenOfType(ASTClassOrInterfaceBodyDeclaration.class);
            int testMethods = 0;
            for (ASTClassOrInterfaceBodyDeclaration decl : declarations) {
                if (!this.isTestMethod(decl)) continue;
                ++testMethods;
            }
            if (testMethods == 0) {
                this.addViolation(data, (Node)node);
            }
        }
        return data;
    }

    private boolean isTestMethod(ASTClassOrInterfaceBodyDeclaration decl) {
        JavaNode node = decl.getDeclarationNode();
        if (node instanceof ASTMethodDeclaration) {
            return AbstractJUnitRule.isTestMethod((ASTMethodDeclaration)node);
        }
        return false;
    }
}

