/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.qname;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

interface ImmutableList<E>
extends List<E> {
    public ImmutableList<E> prepend(E var1);

    @Override
    public int size();

    @Override
    public boolean isEmpty();

    public E head();

    public ImmutableList<E> tail();

    @Override
    public E get(int var1);

    public ImmutableList<E> reverse();

    public <T> ImmutableList<Map.Entry<E, T>> zip(ImmutableList<T> var1);

    @Override
    public Iterator<E> iterator();

    public List<E> toList();

    public static final class ListFactory {
        private static final Nil<?> NIL = new Nil();

        private ListFactory() {
        }

        static ImmutableList<String> split(String input, String regex) {
            return ListFactory.split(input, regex, 0);
        }

        static ImmutableList<String> split(String input, String regex, int limit) {
            int index = 0;
            boolean matchLimited = limit > 0;
            ImmutableList<String> matchList = ListFactory.emptyList();
            Matcher m = Pattern.compile(regex).matcher(input);
            while (m.find()) {
                String match;
                if (!matchLimited || matchList.size() < limit - 1) {
                    if (index == 0 && index == m.start() && m.start() == m.end()) continue;
                    match = input.subSequence(index, m.start()).toString();
                    matchList = matchList.prepend(match);
                    index = m.end();
                    continue;
                }
                if (matchList.size() != limit - 1) continue;
                match = input.subSequence(index, input.length()).toString();
                matchList = matchList.prepend(match);
                index = m.end();
            }
            if (index == 0) {
                return ListFactory.make(input);
            }
            if (!matchLimited || matchList.size() < limit) {
                matchList = matchList.prepend(input.subSequence(index, input.length()).toString());
            }
            if (limit == 0) {
                while (!matchList.isEmpty() && "".equals(matchList.head())) {
                    matchList = matchList.tail();
                }
            }
            return matchList;
        }

        static <E> ImmutableList<E> emptyList() {
            return NIL;
        }

        static <E> ImmutableList<E> make() {
            return ListFactory.emptyList();
        }

        private static <E> ImmutableList<E> fromArray(E[] arr) {
            ImmutableList<E> cur = ListFactory.emptyList();
            if (arr != null) {
                for (E item : arr) {
                    cur = cur.prepend(item);
                }
            }
            return cur;
        }

        @SafeVarargs
        static <E> ImmutableList<E> make(E ... elems) {
            return ListFactory.fromArray(elems);
        }

        private static class ListNode<E>
        extends AbstractImmutableList<E> {
            private final E head;
            private final ImmutableList<E> tail;
            private final int size;
            private SoftReference<ImmutableList<E>> reverseCache;

            private ListNode(E head, AbstractImmutableList<E> tail) {
                this.head = head;
                this.tail = tail;
                this.size = tail.isEmpty() ? 1 : tail.size() + 1;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public E head() {
                return this.head;
            }

            @Override
            public ImmutableList<E> tail() {
                return this.tail;
            }

            @Override
            public E get(int i) {
                if (i < 0 || i > this.size()) {
                    throw new IndexOutOfBoundsException();
                }
                return i == 0 ? this.head() : this.tail().get(i - 1);
            }

            @Override
            public Iterator<E> iterator() {
                return new NodeIterator(this);
            }

            @Override
            public ImmutableList<E> reverse() {
                if (this.reverseCache == null || this.reverseCache.get() == null) {
                    ImmutableList<E> rev = this.buildReverse();
                    ((ListNode)rev).reverseCache = new SoftReference<ListNode>(this);
                    this.reverseCache = new SoftReference<ImmutableList<E>>(rev);
                }
                return this.reverseCache.get();
            }

            private ImmutableList<E> buildReverse() {
                ImmutableList<E> cur = ListFactory.emptyList();
                for (E item : this) {
                    cur = cur.prepend(item);
                }
                return cur;
            }

            @Override
            public List<E> toList() {
                return new ArrayList(this);
            }

            @Override
            public boolean contains(Object o) {
                return Objects.equals(this.head(), o) || this.tail.contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int indexOf(Object o) {
                int i = 0;
                for (E e : this) {
                    if (Objects.equals(e, o)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            @Override
            public int lastIndexOf(Object o) {
                int i = this.reverse().indexOf(o);
                return i < 0 ? i : this.size() - i - 1;
            }

            public String toString() {
                if (this.size() == 1) {
                    return "List(" + this.head() + ")";
                }
                StringBuilder sb = new StringBuilder("List(").append(this.head());
                for (E elem : this.tail()) {
                    sb.append(", ").append(elem);
                }
                return sb.append(")").toString();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ListNode listNode = (ListNode)o;
                return this.size == listNode.size && Objects.equals(this.head, listNode.head) && Objects.equals(this.tail, listNode.tail);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.head, this.tail, this.size);
            }

            private static class NodeIterator<E>
            implements Iterator<E> {
                ImmutableList<E> current;

                NodeIterator(ImmutableList<E> start) {
                    this.current = start;
                }

                @Override
                public boolean hasNext() {
                    return !this.current.isEmpty();
                }

                @Override
                public E next() {
                    E head = this.current.head();
                    this.current = this.current.tail();
                    return head;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private static class Nil<E>
        extends AbstractImmutableList<E> {
            Nil() {
            }

            @Override
            public Iterator<E> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public E get(int i) {
                throw new IndexOutOfBoundsException("Empty list!");
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public E head() {
                throw new IndexOutOfBoundsException("Empty list!");
            }

            @Override
            public ImmutableList<E> tail() {
                throw new IndexOutOfBoundsException("Empty list!");
            }

            @Override
            public ImmutableList<E> reverse() {
                return this;
            }

            @Override
            public boolean contains(Object item) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return false;
            }

            @Override
            public int indexOf(Object o) {
                return -1;
            }

            @Override
            public int lastIndexOf(Object o) {
                return -1;
            }

            public String toString() {
                return "List()";
            }

            @Override
            public List<E> toList() {
                return Collections.emptyList();
            }
        }

        private static abstract class AbstractImmutableList<E>
        implements ImmutableList<E> {
            private AbstractImmutableList() {
            }

            @Override
            public boolean add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(int index, Collection<? extends E> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(int index, E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public E remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ListIterator<E> listIterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ListIterator<E> listIterator(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.toList().toArray(a);
            }

            @Override
            public Object[] toArray() {
                return this.toList().toArray();
            }

            @Override
            public final AbstractImmutableList<E> prepend(E elem) {
                return new ListNode(elem, this);
            }

            @Override
            public E set(int index, E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<E> subList(int fromIndex, int toIndex) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final <T> ImmutableList<Map.Entry<E, T>> zip(ImmutableList<T> right) {
                Iterator thisIt = this.iterator();
                Iterator<T> rightIt = right.iterator();
                ImmutableList result = ListFactory.emptyList();
                while (thisIt.hasNext() && rightIt.hasNext()) {
                    result = result.prepend(new AbstractMap.SimpleImmutableEntry(thisIt.next(), rightIt.next()));
                }
                return result.reverse();
            }
        }
    }
}

