/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile.signature;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSignature;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaSigMask;

public final class JavaOperationSigMask
extends JavaSigMask<JavaOperationSignature> {
    private Set<JavaOperationSignature.Role> roleMask = EnumSet.allOf(JavaOperationSignature.Role.class);
    private boolean coverAbstract = false;

    public void coverAllRoles() {
        this.roleMask.addAll(Arrays.asList(JavaOperationSignature.Role.values()));
    }

    public void restrictRolesTo(JavaOperationSignature.Role ... roles) {
        this.roleMask.clear();
        this.roleMask.addAll(Arrays.asList(roles));
    }

    public void forbid(JavaOperationSignature.Role ... roles) {
        this.roleMask.removeAll(Arrays.asList(roles));
    }

    public void coverAbstract(boolean coverAbstract) {
        this.coverAbstract = coverAbstract;
    }

    public void coverAbstract() {
        this.coverAbstract = true;
    }

    public void forbidAbstract() {
        this.coverAbstract = false;
    }

    @Override
    public boolean covers(JavaOperationSignature sig) {
        return super.covers(sig) && this.roleMask.contains((Object)sig.role) && (this.coverAbstract || !sig.isAbstract);
    }
}

