/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledBlock;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledThrowStatement;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import org.apache.commons.lang3.EnumUtils;

public class ASTSwitchStatement
extends AbstractJavaNode
implements Iterable<ASTSwitchLabel> {
    @Deprecated
    @InternalApi
    public ASTSwitchStatement(int id) {
        super(id);
    }

    @Deprecated
    @InternalApi
    public ASTSwitchStatement(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean hasDefaultCase() {
        for (ASTSwitchLabel label : this) {
            if (!label.isDefault()) continue;
            return true;
        }
        return false;
    }

    public ASTExpression getTestedExpression() {
        return (ASTExpression)this.getChild(0);
    }

    public boolean isExhaustiveEnumSwitch() {
        ASTExpression expression = this.getTestedExpression();
        if (expression.getType() == null) {
            return false;
        }
        if (Enum.class.isAssignableFrom(expression.getType())) {
            Set constantNames = EnumUtils.getEnumMap(expression.getType()).keySet();
            for (ASTSwitchLabel label : this) {
                if (label.getFirstDescendantOfType(ASTName.class) == null) continue;
                constantNames.remove(((ASTName)label.getFirstDescendantOfType(ASTName.class)).getImage());
            }
            return constantNames.isEmpty();
        }
        return false;
    }

    public boolean isFallthroughSwitch() {
        return this.getFirstChildOfType(ASTSwitchLabel.class) != null && this.getNumChildren() != 1;
    }

    @Override
    public Iterator<ASTSwitchLabel> iterator() {
        ArrayList<ASTSwitchLabel> result = new ArrayList<ASTSwitchLabel>(this.findChildrenOfType(ASTSwitchLabel.class));
        for (AbstractJavaNode labeled : this.findChildrenOfType(ASTSwitchLabeledBlock.class)) {
            result.add((ASTSwitchLabel)labeled.getChild(0));
        }
        for (AbstractJavaNode labeled : this.findChildrenOfType(ASTSwitchLabeledExpression.class)) {
            result.add((ASTSwitchLabel)labeled.getChild(0));
        }
        for (AbstractJavaNode labeled : this.findChildrenOfType(ASTSwitchLabeledThrowStatement.class)) {
            result.add((ASTSwitchLabel)labeled.getChild(0));
        }
        return result.iterator();
    }
}

