/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;
import org.apache.commons.lang3.StringUtils;

public class UnnecessaryFullyQualifiedNameRule
extends AbstractJavaRule {
    private static final Logger LOG = Logger.getLogger(UnnecessaryFullyQualifiedNameRule.class.getName());
    private List<ASTImportDeclaration> imports = new ArrayList<ASTImportDeclaration>();
    private String currentPackage;

    public UnnecessaryFullyQualifiedNameRule() {
        super.addRuleChainVisit(ASTPackageDeclaration.class);
        super.addRuleChainVisit(ASTImportDeclaration.class);
        super.addRuleChainVisit(ASTClassOrInterfaceType.class);
        super.addRuleChainVisit(ASTName.class);
    }

    public void start(RuleContext ctx) {
        this.imports.clear();
        this.currentPackage = null;
    }

    @Override
    public Object visit(ASTPackageDeclaration node, Object data) {
        this.currentPackage = node.getPackageNameImage();
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        this.imports.add(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        if (node.getImage().indexOf(46) < 0) {
            return data;
        }
        this.checkImports(node, data);
        return data;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        if (!(node.getParent() instanceof ASTImportDeclaration) && !(node.getParent() instanceof ASTPackageDeclaration)) {
            if (node.getImage().indexOf(46) < 0) {
                return data;
            }
            this.checkImports(node, data);
        }
        return data;
    }

    private boolean declarationMatches(ASTImportDeclaration decl, String name) {
        return name.startsWith(decl.getImportedName()) && name.lastIndexOf(46) == decl.getImportedName().length();
    }

    private boolean couldBeMethodCall(JavaNode node) {
        if (node.getNthParent(2) instanceof ASTPrimaryExpression && node.getNthParent(1) instanceof ASTPrimaryPrefix) {
            int nextSibling = node.getParent().getIndexInParent() + 1;
            if (node.getNthParent(2).getNumChildren() > nextSibling) {
                return node.getNthParent(2).getChild(nextSibling) instanceof ASTPrimarySuffix;
            }
        }
        return false;
    }

    private void checkImports(TypeNode node, Object data) {
        String name = node.getImage();
        if (this.isVariable(node.getScope(), name)) {
            return;
        }
        ArrayList<ASTImportDeclaration> matches = new ArrayList<ASTImportDeclaration>();
        for (ASTImportDeclaration importDeclaration : this.imports) {
            if (!importDeclaration.isImportOnDemand() && name.equals(importDeclaration.getImportedName())) {
                matches.add(importDeclaration);
                continue;
            }
            if (!this.declarationMatches(importDeclaration, name)) continue;
            matches.add(importDeclaration);
        }
        if (matches.isEmpty()) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                String[] importParts = importDeclaration.getImportedName().split("\\.");
                String[] nameParts = name.split("\\.");
                if (importDeclaration.isStatic()) {
                    if (importDeclaration.isImportOnDemand()) {
                        if (!nameParts[nameParts.length - 2].equals(importParts[importParts.length - 1])) continue;
                        matches.add(importDeclaration);
                        continue;
                    }
                    if (!nameParts[nameParts.length - 1].equals(importParts[importParts.length - 1]) || !nameParts[nameParts.length - 2].equals(importParts[importParts.length - 2])) continue;
                    matches.add(importDeclaration);
                    continue;
                }
                if (importDeclaration.isImportOnDemand()) continue;
                if (nameParts[nameParts.length - 1].equals(importParts[importParts.length - 1])) {
                    matches.add(importDeclaration);
                    continue;
                }
                if (!this.couldBeMethodCall(node) || nameParts.length <= 1 || !nameParts[nameParts.length - 2].equals(importParts[importParts.length - 1])) continue;
                matches.add(importDeclaration);
            }
        }
        if (matches.isEmpty()) {
            if (this.isJavaLangImplicit(node)) {
                this.addViolation(data, (Node)node, new Object[]{node.getImage(), "java.lang.*", "implicit "});
            } else if (this.isSamePackage(node, name)) {
                this.addViolation(data, (Node)node, new Object[]{node.getImage(), this.currentPackage + ".*", "same package "});
            }
        } else {
            ASTImportDeclaration firstMatch = this.findFirstMatch(matches);
            if (!this.isReferencingInnerNonStaticClass(name, firstMatch) && !this.isAvoidingConflict(node, name, firstMatch)) {
                String importStr = firstMatch.getImportedName() + (firstMatch.isImportOnDemand() ? ".*" : "");
                String type = firstMatch.isStatic() ? "static " : "";
                this.addViolation(data, (Node)node, new Object[]{node.getImage(), importStr, type});
            }
        }
    }

    private ASTImportDeclaration findFirstMatch(List<ASTImportDeclaration> imports) {
        ASTImportDeclaration result = null;
        for (ASTImportDeclaration importDeclaration : imports) {
            if (!importDeclaration.isStatic()) continue;
            result = importDeclaration;
            break;
        }
        if (result == null) {
            for (ASTImportDeclaration importDeclaration : imports) {
                if (importDeclaration.isStatic()) continue;
                result = importDeclaration;
                break;
            }
        }
        return result;
    }

    private boolean isVariable(Scope scope, String name) {
        String firstSegment = name.substring(0, name.indexOf(46));
        while (scope != null) {
            for (Map.Entry entry : scope.getDeclarations(VariableNameDeclaration.class).entrySet()) {
                if (!((VariableNameDeclaration)entry.getKey()).getName().equals(firstSegment)) continue;
                return true;
            }
            scope = scope.getParent();
        }
        return false;
    }

    private boolean isSamePackage(TypeNode node, String name) {
        Package packageOfType;
        if (node.getType() != null && (packageOfType = node.getType().getPackage()) != null) {
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(0, i);
            }
            return node.getType().getPackage().getName().equals(this.currentPackage) && name.equals(this.currentPackage);
        }
        int i = name.lastIndexOf(46);
        if (i > 0 && (name = name.substring(0, i)).equals(this.currentPackage)) {
            return true;
        }
        if (node.getParent() instanceof ASTPrimaryPrefix || node.getParent() instanceof ASTNameList || node instanceof ASTClassOrInterfaceType) {
            return this.currentPackage != null && name.startsWith(this.currentPackage);
        }
        return false;
    }

    private boolean isJavaLangImplicit(TypeNode node) {
        boolean isJavaLang;
        String name = node.getImage();
        boolean bl = isJavaLang = name != null && name.startsWith("java.lang.");
        if (isJavaLang && node.getType() != null && node.getType().getPackage() != null) {
            String packageName = node.getType().getPackage().getName();
            return "java.lang".equals(packageName);
        }
        if (isJavaLang) {
            return StringUtils.countMatches((CharSequence)name, (char)'.') == 2;
        }
        return false;
    }

    private boolean isReferencingInnerNonStaticClass(String name, ASTImportDeclaration firstMatch) {
        if (firstMatch.isImportOnDemand() && firstMatch.isStatic() && firstMatch.getType() != null) {
            String[] nameParts = name.split("\\.");
            String[] importParts = firstMatch.getImportedName().split("\\.");
            if (nameParts.length == 2 && importParts[importParts.length - 1].equals(nameParts[0])) {
                Class<?>[] declaredClasses;
                for (Class<?> innerClass : declaredClasses = firstMatch.getType().getDeclaredClasses()) {
                    if (!nameParts[1].equals(innerClass.getSimpleName()) || (innerClass.getModifiers() & 8) == 8) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAvoidingConflict(TypeNode node, String name, ASTImportDeclaration firstMatch) {
        if (firstMatch.isImportOnDemand() && firstMatch.isStatic()) {
            String methodCalled = name.substring(name.indexOf(46) + 1);
            for (ASTImportDeclaration aSTImportDeclaration : this.imports) {
                if (Objects.equals(aSTImportDeclaration, firstMatch) || !aSTImportDeclaration.isStatic() || this.declarationMatches(firstMatch, aSTImportDeclaration.getImportedName())) continue;
                if (aSTImportDeclaration.isImportOnDemand()) {
                    if (aSTImportDeclaration.getType() == null) continue;
                    try {
                        for (Method m : aSTImportDeclaration.getType().getMethods()) {
                            if (!m.getName().equals(methodCalled)) continue;
                            return true;
                        }
                        continue;
                    }
                    catch (LinkageError e) {
                        LOG.log(Level.FINE, "Possible incomplete auxclasspath: Error while processing methods", e);
                        continue;
                    }
                }
                if (!aSTImportDeclaration.getImportedName().endsWith(methodCalled)) continue;
                return true;
            }
        }
        String unqualifiedName = name.substring(name.lastIndexOf(46) + 1);
        int unqualifiedNameLength = unqualifiedName.length();
        if (firstMatch.isImportOnDemand() && !firstMatch.isStatic()) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (importDeclaration == firstMatch || importDeclaration.isStatic() || importDeclaration.isImportOnDemand() || importDeclaration.getPackageName().equals(firstMatch.getPackageName()) || !importDeclaration.getImportedSimpleName().equals(unqualifiedName)) continue;
                return true;
            }
        }
        String string = firstMatch.getImportedName();
        String importUnqualified = string.substring(string.lastIndexOf(46) + 1);
        if (!firstMatch.isImportOnDemand() && !firstMatch.isStatic() && !firstMatch.getImportedName().equals(name) && importUnqualified.equals(unqualifiedName)) {
            return true;
        }
        if (this.couldBeMethodCall(node)) {
            String[] nameParts = name.split("\\.");
            String fqnName = name.substring(0, name.lastIndexOf(46));
            if (!fqnName.equals(string) && !firstMatch.isStatic() && !firstMatch.isImportOnDemand() && nameParts.length > 1 && nameParts[nameParts.length - 2].equals(importUnqualified)) {
                return true;
            }
        }
        Set<String> qualifiedTypes = ((SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().keySet();
        for (String qualified : qualifiedTypes) {
            int fullLength = qualified.length();
            if (!qualified.endsWith(unqualifiedName) || fullLength != unqualifiedNameLength && qualified.charAt(fullLength - unqualifiedNameLength - 1) != '.') continue;
            return true;
        }
        return false;
    }
}

