/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class SignatureDeclareThrowsExceptionRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Boolean> IGNORE_JUNIT_COMPLETELY_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"IgnoreJUnitCompletely").defaultValue((Object)false)).desc("Allow all methods in a JUnit testcase to throw Exceptions")).build();
    private boolean junitImported = false;

    public SignatureDeclareThrowsExceptionRule() {
        this.definePropertyDescriptor(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object o) {
        this.junitImported = false;
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.junitImported) {
            return super.visit(node, data);
        }
        for (ASTClassOrInterfaceType type : node.getSuperInterfacesTypeNodes()) {
            if (!this.isJUnitTest(type)) continue;
            this.junitImported = true;
            return super.visit(node, data);
        }
        ASTClassOrInterfaceType type = node.getSuperClassTypeNode();
        if (type != null && this.isJUnitTest(type)) {
            this.junitImported = true;
            return super.visit(node, data);
        }
        return super.visit(node, data);
    }

    private boolean isJUnitTest(ASTClassOrInterfaceType type) {
        Class<?> clazz = type.getType();
        if (clazz == null) {
            if ("junit.framework.Test".equals(type.getImage())) {
                return true;
            }
        } else {
            if (this.isJUnitTest(clazz)) {
                return true;
            }
            while (clazz != null && !Object.class.equals(clazz)) {
                for (Class<?> intf : clazz.getInterfaces()) {
                    if (!this.isJUnitTest(intf)) continue;
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    private boolean isJUnitTest(Class<?> clazz) {
        return clazz.getName().equals("junit.framework.Test");
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if (this.junitImported && this.isAllowedMethod(methodDeclaration)) {
            return super.visit(methodDeclaration, o);
        }
        if (methodDeclaration.getName().startsWith("test")) {
            return super.visit(methodDeclaration, o);
        }
        List methodAnnotations = ((JavaNode)methodDeclaration.getParent()).findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : methodAnnotations) {
            ASTName annotationName = (ASTName)annotation.getFirstDescendantOfType(ASTName.class);
            if (!annotationName.hasImageEqualTo("Override") && !annotationName.hasImageEqualTo("java.lang.Override")) continue;
            return super.visit(methodDeclaration, o);
        }
        this.checkExceptions(methodDeclaration, o);
        return super.visit(methodDeclaration, o);
    }

    private boolean isAllowedMethod(ASTMethodDeclaration methodDeclaration) {
        if (((Boolean)this.getProperty(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR)).booleanValue()) {
            return true;
        }
        return methodDeclaration.getName().equals("setUp") || methodDeclaration.getName().equals("tearDown");
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        if (this.junitImported && ((Boolean)this.getProperty(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR)).booleanValue()) {
            return super.visit(constructorDeclaration, o);
        }
        this.checkExceptions(constructorDeclaration, o);
        return super.visit(constructorDeclaration, o);
    }

    private void checkExceptions(Node method, Object o) {
        List exceptionList = Collections.emptyList();
        ASTNameList nameList = (ASTNameList)method.getFirstChildOfType(ASTNameList.class);
        if (nameList != null) {
            exceptionList = nameList.findDescendantsOfType(ASTName.class);
        }
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
    }

    private void evaluateExceptions(List<ASTName> exceptionList, Object context) {
        for (ASTName exception : exceptionList) {
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, (Node)exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        JavaNode parent = ((JavaNode)exception.getParent()).getParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

