/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class CloneMethodMustImplementCloneableRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.extendsOrImplementsCloneable(node)) {
            return data;
        }
        return super.visit(node, data);
    }

    private boolean extendsOrImplementsCloneable(ASTClassOrInterfaceDeclaration node) {
        ASTClassOrInterfaceType type;
        Class<?> clazz;
        if (node.getType() != null) {
            return Cloneable.class.isAssignableFrom(node.getType());
        }
        ASTImplementsList impl = (ASTImplementsList)node.getFirstChildOfType(ASTImplementsList.class);
        if (impl != null) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                ASTClassOrInterfaceType type2;
                Node child = impl.jjtGetChild(ix);
                if (child.getClass() != ASTClassOrInterfaceType.class || !((type2 = (ASTClassOrInterfaceType)child).getType() == null ? "Cloneable".equals(type2.getImage()) : Cloneable.class.isAssignableFrom(type2.getType()))) continue;
                return true;
            }
        }
        if (node.jjtGetNumChildren() != 0 && node.jjtGetChild(0) instanceof ASTExtendsList && (clazz = (type = (ASTClassOrInterfaceType)node.jjtGetChild(0).jjtGetChild(0)).getType()) != null) {
            return Cloneable.class.isAssignableFrom(clazz);
        }
        return false;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        List blocks;
        ASTMethodDeclarator methodDeclarator = (ASTMethodDeclarator)node.getFirstChildOfType(ASTMethodDeclarator.class);
        if (!this.isCloneMethod(methodDeclarator)) {
            return data;
        }
        ASTClassOrInterfaceDeclaration classOrInterface = (ASTClassOrInterfaceDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (classOrInterface != null && (node.isFinal() || classOrInterface.isFinal()) && node.findDescendantsOfType(ASTBlock.class).size() == 1 && (blocks = node.findDescendantsOfType(ASTBlockStatement.class)).size() == 1) {
            ASTBlockStatement block = (ASTBlockStatement)blocks.get(0);
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)block.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (type != null && type.getType() != null && type.getNthParent(9).equals(node) && type.getType().equals(CloneNotSupportedException.class)) {
                return data;
            }
            if (type != null && type.getType() == null && "CloneNotSupportedException".equals(type.getImage())) {
                return data;
            }
        }
        if (classOrInterface != null && classOrInterface.getType() == null) {
            ASTClassOrInterfaceType type;
            ASTExtendsList extendsList;
            Set<String> classesNames = this.determineTopLevelCloneableClasses(classOrInterface);
            ASTImplementsList implementsList = (ASTImplementsList)classOrInterface.getFirstChildOfType(ASTImplementsList.class);
            if (implementsList != null) {
                List types = implementsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                for (ASTClassOrInterfaceType t : types) {
                    if (!classesNames.contains(t.getImage())) continue;
                    return data;
                }
            }
            if ((extendsList = (ASTExtendsList)classOrInterface.getFirstChildOfType(ASTExtendsList.class)) != null && classesNames.contains((type = (ASTClassOrInterfaceType)extendsList.getFirstChildOfType(ASTClassOrInterfaceType.class)).getImage())) {
                return data;
            }
        }
        this.addViolation(data, node);
        return data;
    }

    private Set<String> determineTopLevelCloneableClasses(ASTClassOrInterfaceDeclaration currentClass) {
        List classes = ((ASTCompilationUnit)currentClass.getFirstParentOfType(ASTCompilationUnit.class)).findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        HashSet<String> classesNames = new HashSet<String>();
        for (ASTClassOrInterfaceDeclaration c : classes) {
            if (c == currentClass || !this.extendsOrImplementsCloneable(c)) continue;
            classesNames.add(c.getImage());
        }
        return classesNames;
    }

    public boolean isCloneMethod(ASTMethodDeclarator node) {
        if (!"clone".equals(node.getImage())) {
            return false;
        }
        int countParams = ((ASTFormalParameters)node.jjtGetChild(0)).jjtGetNumChildren();
        return countParams == 0;
    }
}

