/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.properties.DoubleProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class NPathComplexityRule
extends AbstractJavaMetricsRule {
    private static final Logger LOG = Logger.getLogger(NPathComplexityRule.class.getName());
    @Deprecated
    private static final DoubleProperty MINIMUM_DESCRIPTOR = ((DoubleProperty.DoublePBuilder)((DoubleProperty.DoublePBuilder)((DoubleProperty.DoublePBuilder)((DoubleProperty.DoublePBuilder)DoubleProperty.named((String)"minimum").desc("Deprecated! Minimum reporting threshold")).range((Object)0.0, (Object)2000.0)).defaultValue((Object)200.0)).uiOrder(2.0f)).build();
    private static final IntegerProperty REPORT_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"reportLevel").desc("N-Path Complexity reporting threshold")).range((Object)1, (Object)2000)).defaultValue((Object)200)).uiOrder(1.0f)).build();
    private int reportLevel = 200;

    public NPathComplexityRule() {
        this.definePropertyDescriptor((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MINIMUM_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = this.getReportLevel();
        super.visit(node, data);
        return data;
    }

    private int getReportLevel() {
        double oldProp = (Double)this.getProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR);
        if (oldProp != (Double)MINIMUM_DESCRIPTOR.defaultValue()) {
            LOG.warning("Rule NPathComplexity uses deprecated property 'minimum'. Future versions of PMD will remove support for this property. Please use 'reportLevel' instead!");
            return (int)oldProp;
        }
        return (Integer)this.getProperty((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
    }

    @Override
    public final Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        int npath = (int)JavaMetrics.get(JavaOperationMetricKey.NPATH, node);
        if (npath >= this.reportLevel) {
            this.addViolation(data, node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", node.getQualifiedName().getOperation(), "" + npath});
        }
        return data;
    }
}

