/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.documentation.AbstractCommentRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringProperty;

public class CommentDefaultAccessModifierRule
extends AbstractCommentRule {
    private static final StringProperty REGEX_DESCRIPTOR = new StringProperty("regex", "Regular expression", "", 1.0f);
    private static final String MESSAGE = "To avoid mistakes add a comment at the beginning of the %s %s if you want a default access modifier";
    private final Set<Integer> interestingLineNumberComments = new HashSet<Integer>();

    public CommentDefaultAccessModifierRule() {
        this.definePropertyDescriptor((PropertyDescriptor)REGEX_DESCRIPTOR);
    }

    public CommentDefaultAccessModifierRule(String regex) {
        this();
        this.setRegex(regex);
    }

    public void setRegex(String regex) {
        this.setProperty((PropertyDescriptor)REGEX_DESCRIPTOR, regex);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.interestingLineNumberComments.clear();
        List<Comment> comments = node.getComments();
        for (Comment comment : comments) {
            if (!comment.getImage().matches(((String)this.getProperty((PropertyDescriptor)REGEX_DESCRIPTOR)).trim())) continue;
            this.interestingLineNumberComments.add(comment.getBeginLine());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTMethodDeclarator)decl.getFirstChildOfType(ASTMethodDeclarator.class)).getImage(), "method"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTVariableDeclaratorId)decl.getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getImage(), "field"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        if (decl.isNested() && this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "nested class"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "constructor"));
        }
        return super.visit(decl, data);
    }

    private boolean shouldReport(AbstractJavaAccessNode decl) {
        List parentClassOrInterface = decl.getParentsOfType(ASTClassOrInterfaceDeclaration.class);
        return !parentClassOrInterface.isEmpty() && !((ASTClassOrInterfaceDeclaration)parentClassOrInterface.get(0)).isInterface() && decl.isPackagePrivate() && !this.interestingLineNumberComments.contains(decl.getBeginLine()) && this.hasNoVisibleForTestingAnnotation(decl);
    }

    private boolean hasNoVisibleForTestingAnnotation(AbstractJavaAccessNode decl) {
        boolean result = true;
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)decl.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        if (parent != null) {
            List annotations = parent.findChildrenOfType(ASTAnnotation.class);
            for (ASTAnnotation annotation : annotations) {
                List names = annotation.findDescendantsOfType(ASTName.class);
                for (ASTName name : names) {
                    if (!name.hasImageEqualTo("VisibleForTesting")) continue;
                    result = false;
                    break;
                }
                if (result) continue;
                break;
            }
        }
        return result;
    }
}

