/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.multifile.ClassMirror;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaFieldSigMask;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaFieldSignature;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSigMask;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSignature;

final class ClassStats
implements ClassMirror {
    private Map<JavaOperationSignature, Set<String>> operations = new HashMap<JavaOperationSignature, Set<String>>();
    private Map<JavaFieldSignature, Set<String>> fields = new HashMap<JavaFieldSignature, Set<String>>();
    private Map<String, ClassStats> nestedClasses = new HashMap<String, ClassStats>();

    ClassStats() {
    }

    ClassStats getNestedClassStats(String className, boolean createIfNotFound) {
        if (createIfNotFound && !this.nestedClasses.containsKey(className)) {
            this.nestedClasses.put(className, new ClassStats());
        }
        return this.nestedClasses.get(className);
    }

    void addOperation(String name, JavaOperationSignature sig) {
        if (!this.operations.containsKey(sig)) {
            this.operations.put(sig, new HashSet());
        }
        this.operations.get(sig).add(name);
    }

    void addField(String name, JavaFieldSignature sig) {
        if (!this.fields.containsKey(sig)) {
            this.fields.put(sig, new HashSet());
        }
        this.fields.get(sig).add(name);
    }

    @Override
    public boolean hasMatchingOpSig(String name, JavaOperationSigMask mask) {
        for (JavaOperationSignature sig : this.operations.keySet()) {
            if (!mask.covers(sig) || !this.operations.get(sig).contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMatchingFieldSig(String name, JavaFieldSigMask mask) {
        for (JavaFieldSignature sig : this.fields.keySet()) {
            if (!mask.covers(sig) || !this.fields.get(sig).contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countMatchingOpSigs(JavaOperationSigMask sigMask) {
        int sum = 0;
        for (Map.Entry<JavaOperationSignature, Set<String>> e : this.operations.entrySet()) {
            if (!sigMask.covers(e.getKey())) continue;
            sum += e.getValue().size();
        }
        return sum;
    }

    @Override
    public int countMatchingFieldSigs(JavaFieldSigMask sigMask) {
        int sum = 0;
        for (Map.Entry<JavaFieldSignature, Set<String>> e : this.fields.entrySet()) {
            if (!sigMask.covers(e.getKey())) continue;
            sum += e.getValue().size();
        }
        return sum;
    }
}

